#!/usr/bin/env python
# -*- coding: utf-8 -*-
## Script à lancer pour reconstruire un ancêtre

import re,os,sys,time
import n01Genomes
import n00Objets,n01BlockSynthesis,n02Packs,n03Breakpoints,n04CreCycles
import n07CompareOutgroup,n09ChromoConstruct,n10ChromoFile
import n11PairsFile,n12Deletion,n13Clean,n13Combi,n14WriteDef



def _main_(argv):
  
   if len(argv)!=5:
      print "\n   4 arguments are expected:\n \
      -> the clade Name (as 'Yeast' or 'Vertebrate')\n \
      -> delta between G1 and G2 (an int>=0)\n \
      -> detlaO between G1/G2 and the outgroup genomes (an int)\n \
      -> 1 (to choose a specific ancestor)\
      or a nameFile (to do a list of ancestors)\n"
      sys.exit(1)

   group=argv[1]
   delta=argv[2]
   deltaO=argv[3]
   path='../../'+group
   iniShortNameList=n01Genomes.ListShortName(path)
   iniShortNameList.sort()

   if argv[4]=='1':
      for i,x in enumerate(iniShortNameList):
         print i+1,'\t',x
      print "Which ancestor do you want to reconstruct?"
      questionGenome=raw_input("Write the name of your ancestor, the number of \
your 2 genomes G1 and G2 and then those of the outgroup genomes (everything \
seperated with a space).\n")
      qLine=re.split(" ",questionGenome)
      if len(qLine)<4 :
         print "!!! Enter 1 name and at least 3 numbers  !!!!"
         sys.exit(1)
      genomes=[]
      ancestralName=qLine[0]
      for num in qLine[1:]:
         if 0<int(num) and int(num)<=len(iniShortNameList):
            genomes.append(iniShortNameList[int(num)-1])
         else:
            print "!!! All number has to correspond to a genome  !!!!"
            sys.exit(1)
      if int(qLine[1])>int(qLine[2]):
         genomesO=[genomes[1]]
         genomesO.append(genomes[0])
         genomesO.extend(genomes[2:])
         genomes=genomesO
      outgroup=qLine[3:]
      outgroup=map(int,outgroup)
      outgroup.sort()
      outgroup=map(str,outgroup)
      ancestorsList=[(ancestralName,genomes,outgroup)]
   else:
      ancestorsList=[]
      for line in open(argv[4],'r'):
         qLine=line.split(' ')
         if len(qLine)>=4 :
            ancestralName=qLine[0]
            genomes=[]
            for num in qLine[1:]:
               genomes.append(iniShortNameList[int(num)-1])
            outgroup=qLine[3:]
            outgroup=map(int,outgroup)
            outgroup.sort()
            outgroup=map(str,outgroup)
            ancestorsList.append((ancestralName,genomes,outgroup))
   print ancestorsList

   os.system('mkdir '+path+'/40Ancestors')
   for (ancestralName,genomeNames,outgroup) in ancestorsList:
      genomes=[]
      ## Synthesis of all genomes with which we will work 
      for gName in genomeNames:
         g=n00Objets.Genome(gName,path)
         n01BlockSynthesis.defSynthesis(g,path)
         genomes.append(g)
      if genomes[0].name>genomes[1].name:
         genomes[0],genomes[1]=genomes[1],genomes[0]
      g1=genomes[0]
      g2=genomes[1]
      nameDir=g1.name+'.'+g2.name
      for num in outgroup:
         nameDir+='.'+num
      print nameDir

      os.system('mkdir '+path+'/40Ancestors/'+ancestralName)
      os.system('mkdir '+path+'/40Ancestors/'+ancestralName+'/'+nameDir)
      pathAnc=path+'/40Ancestors/'+ancestralName+'/'+nameDir+'/Delta'+delta+'DO'+deltaO+'/'
      os.system('mkdir '+pathAnc)
      os.system('mkdir '+pathAnc+'1PacksBlocks/')
      os.system('mkdir '+pathAnc+'2Rearrangements/')
      os.system('mkdir '+pathAnc+'3PostMacro/')
      os.system('mkdir '+pathAnc+'4Micro/')
      os.system('mkdir '+pathAnc+'5Ancestor/')

      ## (1) On fait la synthese des genomes/genes/genesC/homologues/blocks 
      n01BlockSynthesis.pairsSynthesis(g1,g2,path,delta)
      (blocs1,blocs2)=n01BlockSynthesis.blocks2GenomesSynthesis(g1,g2,path,delta)
      nbBlock=len(blocs1)
      blocsG31=[]
      blocsG32=[]
      for i in range(2,len(genomes)):
         g3=genomes[i]
         n01BlockSynthesis.pairsSynthesis(g1,g3,path,deltaO)
         (b1,b3)=n01BlockSynthesis.blocks2GenomesSynthesis(g1,g3,path,deltaO)
         if g1.name<g3.name:
            blocsG31.append(b3)
         else:
            blocsG31.append(b1)
         n01BlockSynthesis.pairsSynthesis(g2,g3,path,deltaO)
         (b2,b3)=n01BlockSynthesis.blocks2GenomesSynthesis(g2,g3,path,deltaO)
         if g2.name<g3.name:
            blocsG32.append(b3)
         else:
            blocsG32.append(b2)

      ## (1bis) On supprime les blocs de G1/G2 sans equivalent ds aucun G12/G3
      (blocs1,blocs2)=n01BlockSynthesis.suppressionBlocs(blocs1,blocs2,genomes[2:])

      ## (2) On fait la synthese des packs/breakpoints/cycles
      packs1,packs2,nbpack=n02Packs.packs2GenomesSynthesis(blocs1,blocs2,genomes[2:])
      breakpoints1,breakpoints2=n03Breakpoints.breakpoints2GenomesSynthesis(packs1,packs2)

      #####################################################################
      cycles=0
      tps=time.time()
      t=5*60 ##(5min)
      try:
         fileD=pathAnc+'2Rearrangements/'+g1.name+'.'+g2.name+'.'+delta+'.cycles.txt'
         packFile=pathAnc+'1PacksBlocks/'+g1.name+'.'+g2.name+'.'+delta+'.Packs.txt'
         nbCycle,maxLenC,(delBl,cycles)=n04CreCycles.cycles2GenomesSynthesis(packs1,packs2,breakpoints1,breakpoints2,fileD,packFile,time=tps+t)
      except ValueError:
         # affichage du message d'erreur
         print "%s" % sys.exc_info()[1]
      #####################################################################

      time.sleep(2)
      if cycles:
         sumFile=pathAnc+'5Ancestor/'+ancestralName+'.'+g1.name+'.'+g2.name+'.sum'
         n01Genomes.head(sumFile,ancestralName,g1.name,g2.name,map(lambda x:x.name,genomes[2:]))
         blFile=pathAnc+'1PacksBlocks/'+g1.name+'.'+g2.name+'.'+delta+'.BlockspostPack.txt'
         nbBlockAP,nbVBlock=n01BlockSynthesis.writeFinalBl(blFile,blocs1,blocs2,delBl)

         ## (3) On compare avec les outgroups
         fileR=pathAnc+'2Rearrangements/'+g1.name+'.'+g2.name+'.'+delta
         brkptsValides,brkptsCrees,blocsNonValides,blocsValides,NBREAR=n07CompareOutgroup.outgroupComparison(
                        cycles,genomes,blocsG31,blocsG32,pathAnc,fileR)
         listeResult=n09ChromoConstruct.constructChromo(brkptsValides,brkptsCrees,blocsNonValides,blocsValides,pathAnc+'3PostMacro/')
         n10ChromoFile.oneChromoFiles(listeResult,g1,g2,pathAnc+'3PostMacro/')

         ###################################################
         ## MICROREARRANGEMENTS
         ################################################
         shNameList=genomeNames
   
         pathGenome=path+'/01Genomes/'
         pathBlock=path+'/11Blocks/Delta'
         name1=g1.name
         name2=g2.name
         
         ## 1- Construction of .ORTH.PAIRS
         old_sign1,old_sign2,old2news1,old2news2,macro_score1,macro_score2=n11PairsFile.orthPairsCh(group,
         pathBlock+delta+'/OrthBlocks/'+name1+'.'+name2,pathAnc+'3PostMacro/',name1,name2)
         n01Genomes.macropart(sumFile,ancestralName,g1.name,g2.name,nbBlock,nbpack,
         nbCycle,maxLenC,nbBlockAP,nbVBlock,NBREAR,len(listeResult),len(old2news1.keys()),len(old2news2.keys()))

         ## 2- Construction of .ORTH.SYNT
         os.system('./go_syntorthdist2 '+pathAnc+'3PostMacro/ '+ name1+'.'+name2)
         # on modif dico1,dico2
         n11PairsFile.modifDico(pathAnc+'3PostMacro/',name1,name2,old2news1,old2news2)
         n11PairsFile.rewriteDef(pathAnc+'3PostMacro/',pathAnc+'4Micro/',name1,name2)

         ## 3- Delete included/duplicated blocks/genes 
         blocs,blocs1,blocs2,dicoOrthos1,dicoOrthos2,new2old1,new2old2,nbMiBl1=n12Deletion.readSynts(pathAnc+'3PostMacro/',name1,name2)
         ## 4- Delete the 'doublons' (one old gene for several new one)
         blocs1=map(lambda x:[x],blocs1)
         blocs2=map(lambda x:[x],blocs2)
         n13Clean.update(blocs,blocs1,blocs2,old2news1,old2news2,dicoOrthos1,dicoOrthos2,new2old1,new2old2)
         blocs,blocs1,blocs2=n13Clean.fusion(blocs,blocs1,blocs2)
         print '\nThere are',len(blocs),'blocks after fusion of successive blocks'
         n13Clean.erase_double(old2news1,blocs1,blocs2,dicoOrthos1,blocs)
         n13Clean.update(blocs,blocs1,blocs2,old2news1,old2news2,dicoOrthos1,dicoOrthos2,new2old1,new2old2)
         n13Clean.erase_double(old2news2,blocs2,blocs1,dicoOrthos2,blocs)
         n13Clean.update(blocs,blocs1,blocs2,old2news1,old2news2,dicoOrthos1,dicoOrthos2,new2old1,new2old2)
         if len(filter(lambda x:len(x)>1,old2news1.values()+old2news2.values())):
            print 'ERROR IN ERASE DOUBLE 2',filter(lambda x:len(x)>1,old2news1.values()+old2news2.values())

         ## 5- Delete blocks without homologs in outgroups (after fusion)
         dicosList1,dicosList2=n13Clean.syntheseHomo(group,pathBlock+deltaO+'/OrthBlocks/',
         shNameList,old2news1,old2news2,old_sign1,old_sign2,new2old1,new2old2)
         blocs,blocs1,blocs2=n13Clean.delWHomo(dicosList1,dicosList2,blocs,blocs1,blocs2,new2old1,new2old2,dicoOrthos1,dicoOrthos2)
         print 'and',len(blocs),'blocks have at least one homologs in one outgroups'
         nbMiBl2=len(blocs)
         n13Clean.update(blocs,blocs1,blocs2,old2news1,old2news2,dicoOrthos1,dicoOrthos2,new2old1,new2old2)
         n13Clean.rewriteDef(pathAnc+'4Micro/',name1,name2,new2old1,new2old2)

         ## 5- On simplifie les ajencements difficiles impliquant trop d'inversions
         listCons,microScore,NBREARi=n13Combi.combi(dicosList1,dicosList2,blocs,blocs1,blocs2,new2old1,new2old2,pathAnc+'4Micro/')

         ## 6- On reecrit
         nbChro=n14WriteDef.reWrite(pathAnc+'4Micro/',pathAnc+'5Ancestor/',ancestralName,name1,name2,listCons,microScore,blocs,blocs1,blocs2,new2old1,new2old2,old2news1,dicoOrthos1,dicoOrthos2)
         n14WriteDef.writeNewFiles(pathAnc+'5Ancestor/',pathGenome,ancestralName,name1,name2)
         n01Genomes.micropart(sumFile,ancestralName,g1.name,g2.name,nbMiBl1,nbMiBl2,NBREARi,nbChro)


if __name__=="__main__":
   _main_(sys.argv)
   #_main_([0,'Lachancea','3','1'])
   #_main_([0,'Yeast','3','3','ExempleFileForAnChro.txt']) 
   #_main_([0,'Yeast','4','3','1'])
   #_main_([0,'Vertebrate','1','5','1'])
 
 
 