# functions for finding maximal directed acyclic graphs using networkx

import networkx
import sys
import random

# assumes input is a space-delimited list of links.  anything after the first two fields is ignored.
netfile = open(sys.argv[1])

linklist = netfile.readlines()
netfile.close()

g = networkx.DiGraph()

for link in linklist:
	#print link
	if link.startswith('#'):
		continue
	nodes = link.strip().split(' ')

	node_tup = [(nodes[0],nodes[1])]
	# networkx graph objects are basically dictionaries, so .copy() method works
#	h = g.copy()
	g.add_edges_from(node_tup)
# then do a 'topological sort with grouping' to find a meaningful sort of the network
# see http://stackoverflow.com/questions/4073119/topological-sort-with-grouping

# TOPOSORT PSEUDOCODE

# FIND IN-DEGREE OF EACH NODE
# 1) LABEL ALL WITH DEGREE == 0 AS ORDER 0
# 2) REMOVE STEP 0 NODES FROM GRAPH
# 3) GO TO 1, LABEL DEGREE == 0 AS ORDER 1, REMOVE NODES FROM GRAPH
# 4) REPEAT 3 UNTIL ALL NODES HAVE BEEN VISITED, INCREASING ORDER AS YOU GO
def topo_it(g):
	nextstep = []
	for node in g.nodes():
		indeg = g.in_degree(node)
		if indeg == 0:
			nextstep.append(node)
	g.remove_nodes_from(nextstep)
	return [g,nextstep]
	# returns a graph for the next iteration, and the nodes for the current order

# loop to contain toposort iterations
step = 1
steps = {}

arcsetless_net = g.copy()

while g.number_of_nodes() > 0:
	[g,stepnodes] = topo_it(g)
	steps[step] = stepnodes
	step += 1

# steps var contains sorted nodes in grouped order
for s in steps.keys():
	print s, ' '.join(steps[s])
