#!usr/bin/Rscript
# extract an edge list with nodes properly named from a newick tree
# using ape
treename = 'MOtree_GLrun/TheTree.INodes.ph'

require(ape)
tree = read.tree(treename)

tips = tree$tip.label
nodes = tree$node.label
edges = tree$edge

maps = append(tips,nodes)

parent = maps[edges[,1]]
child = maps[edges[,2]]

edgelist = cbind(parent,child)

write.table(edgelist,paste(treename,'parentage',sep='.'),col.name=FALSE,row.name=FALSE,quote=FALSE)
