#!usr/bin/Rscript
# for shuffling network for a null distribution for distances between nodes in 2nd net
# for hgt dep net comparison to metabolic net 
# max 12/5/13
# updated 5/21/14 to use a non-crazy dataset

#if (length(commandArgs) > 1) {
replicate = commandArgs(trailingOnly=TRUE)[2]
#} else {
#stop()
#replicate=1
#}
require(igraph)
shuf_num = 10
perm_intensity = 5

count_intrapath = function(net,pathway) {
	count = 0
	for (path1 in pathwayS) {
#		print(path1)
		kos1 = pathway[pathway[,2] == path1,1]
#		print(kos1[!(kos1 %in% rownames(net))])
		path_in = net[kos1,,drop=FALSE]
		count = count + sum(path_in[,kos1])
		}
	return(count)
	}

load('processed_data/hgt_net_dag_transreduced_repro.Rdat')
pos_assoc = as.matrix(adjmat)
#pos_assoc = as.matrix(read.table('hgt_net_treduce_adjmat_071614.txt',header=T))
pathway = as.matrix(read.table('processed_data/annots_helperfiles/pathway.parsed120113.cut'))	# maps to kos
pathway = pathway[which(pathway[,1] %in% rownames(pos_assoc)),]
pathwayS = unique(pathway[,2])


kos = rownames(pos_assoc)

num_edges = sum(pos_assoc)
pos_net = graph.adjacency(pos_assoc)

true_count = count_intrapath(pos_assoc,pathway)
sim_counts = c()

for (i in 1:shuf_num) {
	print(i)
	# shuffle graph
	print('perming')
	shuf = rewire(pos_net,mode='simple',niter=(num_edges*perm_intensity))
	print('perm done')
	# repeat counting
	sim_counts[i] = count_intrapath(get.adjacency(shuf),pathway)
	}

write.table(true_count,'true_counts_pathway_082415.txt',row.name=FALSE,col.name=FALSE,quote=FALSE)
write.table(sim_counts,paste('sim_counts_pathway_082415.txt.',replicate,sep=''),col.name=FALSE,row.name=FALSE,quote=FALSE)
	
#p = length(which(sim_counts>=true_count)) / shuf_num
