#!usr/bin/Rscript
library(plotrix)

size_factor = 1

# make a network display showing two kinds of edges
# modified to collapse grouped nodes together
if (!(exists('net'))) { 
net = as.matrix(read.table('processed_data/treduced_hgt_net_list.cyto.repro'))
}

ordering = read.table('processed_data/reproduced_analysis/hgt_toposort_attr_090915.txt')

#rownames(ordering) = ordering[,1]
#ordering = ordering[,2]

allnodes = unique(append(unique(as.vector(net[,1])),unique(as.vector(net[,2]))))

# process paths for coordinates to plot in ordered clusters
ordinals = (unique(ordering[,]))
labels = rownames(ordering)
#labels = ordering[,1]

nums_ordinal = c()
for (ordinal in ordinals) {
	nums_ordinal[ordinal] = length(which(ordering==ordinal))
	}

link_counts = matrix(rep(0,max(ordinals)^2),max(ordinals))

for (ord1 in ordinals) {
#	print(ord1)
	for (ord2 in ordinals) {
		rank1 = rownames(ordering)[ordering[,] == ord1]
		rank2 = rownames(ordering)[ordering[,] == ord2]
		subnet = net[net[,1] %in% rank1,2]
#		print(subnet)
		
		subnet = subnet[subnet %in% rank2]
		link_counts[ord1,ord2] = length(subnet)/size_factor
		}
	}

link_counts = link_counts*3


#pdf('arc_diagram_path_121113.pdf')	
plot(1,1,xlim = c(-1,max(ordinals)+1.5),ylim = c(-1,1),axes=FALSE,type='n',cex.lab=2)	#,xlab='Ordered pathways',ylab='Feedback edges                   Forward edges')
par(mar=c(1,1,1,1))
text(c(.1,.1),c(-.5,.5),labels=c('Feedback edges','Forward edges'),cex=1,srt=90)
text(4,-.8,labels=c('Ordered pathway groups'),cex=2)

cols = rainbow(max(ordinals))

positions = c()
for (ordinal in ordinals) {
	group = rownames(ordering)[ordering[,]==ordinal]
	slots = seq(-.15,.15,.5/nums_ordinal[ordinal])
	for (node in 1:length(group)) {
		positions[group[node]] = ordinal + slots[node]		
#		points(ordinal,0,cex = sqrt(nums_ordinal[ordinal]*4),col=cols[ordinal],pch=19)
		points(ordinal,0,cex = log(nums_ordinal[ordinal])/size_factor,col=cols[ordinal],pch=19)

		}
	}
# now add edges to plot
fas = 0
for (row in 1:nrow(link_counts)) {
for (col in 1:ncol(link_counts)) {
#	print(edge)
#	out = net[edge,1]
#	inedge = net[edge,2]
	# handle feedback edges
	center = mean(c(row,col))
	rad = abs(center-row)
#	width = 0
	width = log(link_counts[row,col])
#	cat(row,col,rad,center,width,'\n')
	cat(row,col,width,'\n')
	if (row >= col) {
		draw.arc(center, 0,radius=rad, -(0:10)/10, deg2 = -(0:18)*10, col = "red",lwd=width)
		# and forward edges
		fas = fas+1
#		print(ordering[out,])
#		print(ordering[inedge,])
		} else {
		draw.arc(center, 0,radius=rad, (0:10)/10, deg2 = (0:18)*10, col = "blue",lwd=width)
		}
		}
	}

positions = c()
for (ordinal in ordinals) {
        group = rownames(ordering)[ordering[,]==ordinal]
        slots = seq(-.15,.15,.5/nums_ordinal[ordinal])
        for (node in 1:length(group)) {
                positions[group[node]] = ordinal + slots[node]
#               points(ordinal,0,cex = sqrt(nums_ordinal[ordinal]*4),col=cols[ordinal],pch=19)
                points(ordinal,0,cex = log(nums_ordinal[ordinal])/size_factor,col=cols[ordinal],pch=19)

                }
        }

	
#dev.off()
# recall that link_counts was multiplied by 3 for visual purposes...
tables3 = cbind(ordinals,nums_ordinal,rowSums(link_counts/3),colSums(link_counts/3))
colnames(tables3) = c('Rank','Number of genes','Total out-degree','Total in-degree')
print('this is table s3:')
print(tables3)

