# plot presence of genes on tree

require(ape)
tree= read.tree('gainLoss_results/MOtree_GLrun/TheTree.INodes.ph')

# deals with super-long archaea branch
tree$edge.length[which(tree$edge.length==10.1)]=.012

ballsize=.9

pres = as.matrix(read.table('gainLoss_results/MOtree_GLrun/AncestralReconstructPosterior.txt.pres_probs',header=T))
#gains = as.matrix(read.table('~/Dropbox/LGT_project/gain_loss_inference/MOtree_GLrun/021214_MOtree_gains.txt',header=T))

#allkos = read.table('~/Dropbox/LGT_project/gain_loss_inference/source_data/cicc_newkegg_msa.gl.meta')

# edge list orders on this list of tips+nodes i guess
allnodes = append(tree$tip.label,tree$node.label)
nodelist = allnodes[tree$edge[,2]]

# in my dataset i have labeled each branch with the node that it ends in
# so taking the phylo object's edgelist and just taking the target node
# will give me the mapping from the tree to my data

plot_2genes_tree = function(kovec,figname) {


#edgecols = rgb(sqrt(datlist),0,sqrt(1-datlist),1)
#postscript(figname,width=7,height=7)
plot.phylo(tree,cex=.1,edge.color='black',edge.width=.5,use.edge.length=TRUE)
#plot.phylo(tree,cex=.1,type='fan',edge.color=edgecols,edge.width=.5)	#,use.edge.length=FALSE)
#edgelabels(text=NULL,pch=19,cex=datlist*.1,col='blue')
#edgelabels(text=NULL,pch=19,cex=otherlist*.1,col='green')

rainbowed = rainbow(length(kovec))
print(length(kovec))

# treating first gene as start of pathway - looking at presence 
# could be put into loop but whatever
ko = 1
kolist = pres[nodelist,kovec[ko]]
names(kolist) = nodelist
#kolist[kolist[tree$tip.label] > 0] = 1
kolist[tree$tip.label[which(kolist[tree$tip.label] > 0)]] = 1
#print(kolist)
#print(summary(kolist))
edgelabels(text=NULL,pch=19,cex=kolist*ballsize,col=rainbowed[ko],adj=(ko*.01)+.49)

for (ko in 2:length(kovec)) {
#	print(kovec[ko])
	kolist = pres[nodelist,kovec[ko]]
	names(kolist) = nodelist	
	#kolist[kolist[tree$tip.label] > 0] = 1
	kolist[tree$tip.label[which(kolist[tree$tip.label] > 0)]] = 1
#	print(summary(kolist))
#edgelabels(kolist,pch=19,cex=.05,adj=c(-3,0),frame='none')	#,cex=kolist*ballsize,col=rainbowed[ko],adj=c(ko*.01,ko*.001)+.49)

			edgelabels(text=NULL,pch=19,cex=kolist*ballsize,col=rainbowed[ko],adj=c(ko*.01,ko*.01)+.49)
	}

text(1.280,-15,labels='Presence probability',cex=.6)
text(2*c(.480,.560,.640,.720,.8),c(1.50,1.50,1.50,1.50,1.5),labels = c('1.0','0.75','0.5','0.25','0'),cex=.6)
for (i in 1:length(kovec)) {
	text(.80,.70+i*15,cex=.6,labels = kovec[i])
	points(.960,.70+i*15,pch=19,cex=ballsize,col=rainbowed[i])
	points(1.120,.70+i*15,pch=19,cex=ballsize*.75,col=rainbowed[i])
	points(1.280,.70+i*15,pch=19,cex=ballsize*.5,col=rainbowed[i])
	points(1.440,.70+i*15,pch=19,cex=ballsize*.25,col=rainbowed[i])
	
	}

#for (i in seq(0,1,by=.2)) {
#segments(100,10+i*15,105,10+i*15,col = rgb(sqrt(i),0,sqrt(1-i),1),lwd=.5)
#text(108,10+i*15,cex=.3,labels = i)
#points(112,10+i*15,pch=19,cex=i*.1)
#}
#text(97,17,labels='Pr(gene1 present)',cex=.3,srt=90)
#text(115,17,labels='Pr(gene2 gained)',cex=.3,srt=-90)
#dev.off()

}

rbsL_rbsS = c('K01601','K01602')
urtA_rbsS = c('K11959','K01602')

plot_2genes_tree(rbsL_rbsS,'rbslrbss.ps')
plot_2genes_tree(urtA_rbsS,'urtarbss.ps')
