# for plotting te presence of characters (genes) on branches of a  phylogeny 

library(ape)
tree= read.tree('gainLoss_results/MOtree_GLrun/TheTree.INodes.ph')

ballsize=.75

pres = as.matrix(read.table('gainLoss_results/MOtree_GLrun/AncestralReconstructPosterior.txt.pres_probs',header=T))
#gains = as.matrix(read.table('~/Dropbox/LGT_project/gain_loss_inference/MOtree_GLrun/021214_MOtree_gains.txt',header=T))

#allkos = read.table('~/Dropbox/LGT_project/gain_loss_inference/source_data/cicc_newkegg_msa.gl.meta')

# edge list orders on this list of tips+nodes i guess
allnodes = append(tree$tip.label,tree$node.label)
nodelist = allnodes[tree$edge[,2]]

# in my dataset i have labeled each branch with the node that it ends in
# so taking the phylo object's edgelist and just taking the target node
# will give me the mapping from the tree to my data

#presko = 'K02844'
#gainko = 'K13284'

# function to plot everything - altered to plot directly to output, rather than to a file.
#plot_2genes_tree = function(kovec,figname) {
plot_2genes_tree = function(kovec) {

#datlist = gains[nodelist,kovec[1]]

#gainlist = gains[nodelist,kovec[3]]

#otherlist = gains[nodelist,kovec[2]]

#edgecols = rgb(sqrt(datlist),0,sqrt(1-datlist),1)
#pdf(figname)
plot.phylo(tree,cex=.1,edge.color='black',edge.width=.5)	#,use.edge.length=FALSE)
#plot.phylo(tree,cex=.1,type='fan',edge.color=edgecols,edge.width=.5)	#,use.edge.length=FALSE)
#edgelabels(text=NULL,pch=19,cex=datlist*.1,col='blue')
#edgelabels(text=NULL,pch=19,cex=otherlist*.1,col='green')

rainbowed = rainbow(length(kovec))
print(length(kovec))

# treating first gene as start of pathway - looking at presence

ko = 1
kolist = pres[nodelist,kovec[ko]]
#print(summary(kolist))
edgelabels(text=NULL,pch=19,cex=kolist*ballsize,col=rainbowed[ko],adj=(ko*.33)-.33)

for (ko in 2:length(kovec)) {
	print(kovec[ko])
	kolist = pres[nodelist,kovec[ko]]
	print(summary(kolist))
	edgelabels(text=NULL,pch=19,cex=kolist*ballsize,col=rainbowed[ko],adj=(ko*1)-1)
	}

for (i in 1:length(kovec)) {
	text(85,70+i*15,cex=.6,labels = kovec[i])
	points(120,70+i*15,pch=19,cex=ballsize,col=rainbowed[i])
	points(140,70+i*15,pch=19,cex=ballsize*.75,col=rainbowed[i])
	points(160,70+i*15,pch=19,cex=ballsize*.5,col=rainbowed[i])
	points(180,70+i*15,pch=19,cex=ballsize*.25,col=rainbowed[i])
	
	}

#for (i in seq(0,1,by=.2)) {
#segments(100,10+i*15,105,10+i*15,col = rgb(sqrt(i),0,sqrt(1-i),1),lwd=.5)
#text(108,10+i*15,cex=.3,labels = i)
#points(112,10+i*15,pch=19,cex=i*.1)
#}
#text(97,17,labels='Pr(gene1 present)',cex=.3,srt=90)
#text(115,17,labels='Pr(gene2 gained)',cex=.3,srt=-90)
#dev.off()

}

# now, actually make the parts of figure 3 happen
rbsL_rbsS = c('K01601','K01602')
urtA_rbsS = c('K11959','K01602')

plot_2genes_tree(rbsL_rbsS)
plot_2genes_tree(urtA_rbsS)


