require(ape)

figname = 'all_topos_plotted_MOtree_100814.ps'


tree= read.tree('gainLoss_results/MOtree_GLrun/TheTree.INodes.ph')

# deals with super-long archaea branch
tree$edge.length[which(tree$edge.length==10.1)]=.1


gains = as.matrix(read.table('gainLoss_results/MOtree_GLrun/AncestralReconstructPosterior.txt.gain_probs',header=T))


ordering = read.table('processed_data/reproduced_analysis/hgt_toposort_attr_090915.txt',header=T)
ranks = 1:max(ordering[,1])
allkos = rownames(ordering)

order_mat = matrix(rep(0,max(ranks)*nrow(gains)),nrow(gains))
rownames(order_mat) = rownames(gains)

# edge list orders on this list of tips+nodes i guess
allnodes = append(tree$tip.label,tree$node.label)
nodelist = allnodes	#[tree$edge[,2]]

# in my dataset i have labeled each branch with the node that it ends in
# so taking the phylo object's edgelist and just taking the target node
# will give me the mapping from the tree to my data

#postscript(figname)
plot.phylo(tree,cex=.1,edge.color='black',edge.width=.5,use.edge.length=TRUE)

#edgelabels(text=NULL,pch=19,cex=datlist*.1,col='blue')
#edgelabels(text=NULL,pch=19,cex=otherlist*.1,col='green')

rainbowed = rainbow(max(ranks))


for (rank in ranks) {
#	print(rank)
	rankos = rownames(ordering[ordering[,1]==rank,1,drop=FALSE])
	order_mat[,rank] = rowSums( gains[,rankos,drop=FALSE] ) 
	
	
	}

#scaled_mat = scale(order_mat,center=FALSE)

#scaled_mat = order_mat 

#for (node in nrow(scaled_mat)) {
#	scaled_mat[node,] = scaled_mat[node,] / sum(scaled_mat[node,])
#	}


scaled_mat = t(scale(t(order_mat),center=FALSE))

offset = .0075
#coords = matrix(c(-offset,0,offset,-offset,0,offset,offset,offset,offset,0,0,0),6)
for (rank in 1:ncol(scaled_mat)) {
	print(rank)	

edgelabels(text=NULL,pch=19,adj=c(.5+rank*offset,-.2),cex=1.5*log2(scaled_mat[,rank]+.001),col=rainbowed[rank])


points(1.45,rank*20+150,col=rainbowed[rank],pch=19,cex=2)
text(1.55,rank*20+150,pch=19,label=rank)

	}
text(1.5,300,label='topological rank')


#dev.off()

