#!/usr/bin/env ruby

require 'rexml/document'
require 'set'

ARGV.each do |filename|
	doc = nil
	File.open(filename) do |f| 
		doc = REXML::Document.new(f)
		exclude = Set.new
		inferred = []

		REXML::XPath.each(doc, 'graph/node/att[@name = "type" and @value="terminal"]') do |node| 		
		  exclude << node.parent.attributes["label"]
		end

		REXML::XPath.each(doc, 'graph/node/att[@name = "type" and @value="anchor"]') do |node| 		
		  exclude << node.parent.attributes["label"]
		end

		REXML::XPath.each(doc, 'graph/node') do |node| 		
			unless exclude.include? node.attributes["label"]
				inferred << [node.attributes['label'], 
							 REXML::XPath.first(node,'./att[@name="name"]').attributes["value"]]
			end
		end

		File.open("#{filename}.flat", 'w') do |f| 
			f.write("Entrez\tSymbol\n")
			f.write(inferred.map{ |i| i.join("\t")}.join("\n"))
		end
	end
end	
