#!/usr/bin/env ruby

require 'nokogiri'

signatures = {}
ARGV.each do |filename|
	doc = Nokogiri::XML(File.open(filename))
	doc.remove_namespaces!
	signatures[filename] = doc.xpath('//node[not(att/@value = "terminal")]/@id').map(&:value)
end

signatures.each do |k,v|
	puts "#{k}:\t#{v.join("\t")}"
end
