import numpy as np
import pandas as pd
import scipy.stats as sps

from glob import glob

tissue_filename = 'Tumor_colon_diff_exp.txt'
random_filenames = glob('random/random_*_Tumor_colon_diff_exp.txt')

def read_dataset(filename):
    ds = pd.read_table(filename)
    ds['scores'] = ds.expression.str.split('|')
    
    return { r[1].anchor: r[1].scores for r in ds.iterrows() }

tissue = read_dataset(tissue_filename)
random = [read_dataset(x) for x in random_filenames]

scores = {k: sps.mannwhitneyu(v, np.hstack(x[k] for x in random))
          for k,v in tissue.iteritems()}
    
