import sys
import numpy as np 

sys.path.append('/home/bnet/atiasnir/challenge')
import graph
import netrand

np.set_printoptions(linewidth=120)

g = graph.read_network('/home/bnet/atiasnir/challenge/input.simple')
g.data = g.data * np.random.normal(3,2.0,size=(g.nnz,))
g = (g + g.T) / 2.0

with open('step1.txt', 'w') as f:
    netrand.sparse_to_file(g, f, [str(x) for x in range(g.shape[0])], False);

seed = np.random.randint(10000)
print "seed=", seed
print g.todense()
print "------------------------"
while netrand.shuffle_edges(g, True, 1, seed) == 0:
    seed = np.random.randint(10000)
    print "seed=", seed
print g.todense()

with open('step2.txt', 'w') as f:
    netrand.sparse_to_file(g, f, [str(x) for x in range(g.shape[0])], False);
