#!/home/bnet/atiasnir/app/R/bin/Rscript

root.folder <- '/home/bnet/atiasnir/data/dror/'

argv <- commandArgs(trailingOnly = T)
if (length(argv) > 0) {
	distances <- read.csv(argv[1], sep="\t", header=F, col.name=c('from', 'to', 'distance'))
	alt.sf.distnaces <- read.csv(argv[2], sep="\t", header=F, col.name=c('from', 'to', 'distance'))
	out.filename <- argv[3]
} else {
	distances <- read.csv(paste(root.folder, 'rake2/core.spliceosome.distances.txt', sep=''), sep="\t", header=F, col.name=c('from', 'to', 'distance'))
	#targets.distances <- read.csv(paste(root.folder, 'data_jul_31/sf_sharing_targets_distances.txt', sep=''), sep="\t", header=F, col.name=c('from', 'to', 'distance'))
	alt.sf.distnaces <- read.csv(paste(root.folder, 'rake2/alt.sf.distances.txt', sep=''), sep="\t", header=F, col.name=c('from', 'to', 'distance'))
	out.filename <- '/vol/scratch/atiasnir/sf_ppi_distances.png'
}


network.mean = 3.95415
network.std = 0.00012
ds <- list(Core=distances$distance, ASF=alt.sf.distnaces$distance)


if(!interactive()) {
	png(out.filename, height=1024, width=1024)
}

boxplot(ds, col='steelblue')
points(1:2, sapply(ds, mean), col='red', pch='x')
#points(1, network.mean, pch='x', col='blue')
abline(network.mean, 0, col='blue', lty=2)

if(!interactive()) {
	dev.off()
}

#hist(distances$distance)
#plot(density(distances$distance))
