#!/usr/bin/env ruby

require 'set'
require 'gene_info'

raise "This script should be ran on canary as it uses local data" unless ENV['HOST'] == 'canary'

require 'mean'

#module Enumerable
#	def summary
#		sorted = sort
#		min, max = sorted.minmax
#		mean, std = sorted.meanstd
#		q1, q2, q3 = [0.25, 0.5, 0.75].map {|pct| sorted[sorted.size * pct]}
#
#		if block_given?
#			yield min, q1, q2, q3, max, mean, std
#		else
#			$stderr.write("#{ %w{min 25 median 75 max mean std}.map{ |s| "%10.8s" % s}.join('')}\n")
#			$stderr.write("#{ [min, q1, q2, q3, max, mean, std].map{ |s| "%10.8s" % s}.join('')}\n")
#		end
#
#		[min, q1, q2, q3, max, mean, std]
#	end
#end

sample_size = ARGV.shift.to_i

unweighted_distances_filename = '/specific/disk1/home/atiasnir/unweighted.apsp'

distances = []

IO.foreach(unweighted_distances_filename) do |line| 
	from, to, distance = line.chomp.split("\t")

	next if from == to

	distances << distance.to_f
end


sample = distances.sample(sample_size)

puts sample.meanstd.join("\t")
puts distances.meanstd.join("\t")
