#!/usr/bin/env ruby
#

require 'date'

def message(msg, &block)
	$stderr(msg + " - start\n")
	yield if block_given?
	$stderr(msg + " - end\n")
end

data_folder = File.join(File.dirname(__FILE__), "..", "data_" + Date.today.strftime("%b_%d").downcase)
Dir.mkdir data_folder unless Dir.exists? data_folder

CreateEventListScript = File.join(File.dirname(__FILE__), 'create_splicing_event_list.rb')
message("create splicing event list") do 
	`ruby-1.9.2-p136-jaunty #{CreateEventListScript} > #{data_folder}/exons_hg18_names.txt` unless File.size? "#{data_folder}/exons_hg18_names.txt"
end

CreateExonClipXScript = File.join(File.dirname(__FILE__), 'create_exon_clip_intersect.rb')
message("create clip intersection") do 
	`ruby-1.9.2-p136-jaunty #{CreateExonClipXScript} -f #{data_folder}/sf_interactions.txt > #{data_folder}/sf_interactions_for_dror.txt` unless File.size? "#{data_folder}/sf_interactions.txt"
end


