#!/usr/bin/env ruby

require 'fileutils'
require 'set'
require 'gene_info'
require 'returning'
require 'min_heap'

network_filename = ARGV.shift unless ARGV.empty?
sf_list = ARGV.shift unless ARGV.empty?
out_filename = ARGV.shift unless ARGV.empty?

gi = GeneInfo.for_species(GeneInfo::Human)

sf_list ||= File.join(File.dirname(__FILE__), '../data_nov_7/splicosome_core.txt')
sf = Set.new
IO.foreach(sf_list) do |line| 
	name = line.chomp.strip
	if gi.include? name
		sf << gi[name].entrez_id.to_s
	else
		$stderr.puts "Cannot map #{name}"
	end
end

### def read_network(filename)
### 	returning (Hash.new { |hash, key| hash[key] = {} }) do |network|
### 		IO.foreach(filename) do |line| 
### 			from, to, confidence = line.chomp.split(/\s+/).first(3)
### 			confidence = 1
### 			network[from][to] = confidence
### 			network[to][from] = confidence
### 		end
### 	end
### end
### 
### def shortest_paths(from, to, network)
### 	#returning (Hash.new(Float::INFINITY)) do |distances|
### 	distances = Hash.new(Float::INFINITY)
### 	distances[from] = 0
### 	queue = MinHeap.new(network.keys) {|u| distances[u]}
### 
### 	until queue.empty? || to.empty?
### 		#u = queue.min_by {|v| distances[v] }
### 		u = queue.min
### 		queue.pop
### 		to.delete(u)
### 
### 		break if u == Float::INFINITY
### 
### 		network[u].each do |v, d|
### 			alt = distances[u] + d
### 			distances[v] = alt if alt < distances[v] 
### 			queue.update(v)
### 		end	
### 	end
### 
### 	distances
### end

#network = read_network(network_filename)

FileUtils.rm_f(out_filename)
ShortestPaths = File.join(File.dirname(__FILE__), '../src/shortest_paths/shortest_paths')

sf= sf.to_a
while sf.size > 1
	puts "iteration #{sf.size}"
	current = sf.shift
	#distances = shortest_paths(current, sf + [], network)
	File.open(out_filename, 'a') do |f| 
		IO.popen("#{ShortestPaths} #{network_filename} #{current} #{sf.join(' ')}") do |p|
			p.each do |l|
				f.write l
				#f.puts [current, g, distances[g]].join("\t")
			end	
		end
	end
end
