import sys
import math
from graph_tool.all import *

network_filename = sys.argv[1] if (len(sys.argv) >= 2) else "human-ppi.integrated.net"
sf_filename = sys.argv[2] if (len(sys.argv) >= 3) else "splicosome_core.entrez.txt"
out_filename = sys.argv[3] if (len(sys.argv) >= 4) else None

sys.stderr.write("network: " + network_filename + "\n")
sys.stderr.write("sfs: " + sf_filename + "\n")

network = graph_tool.Graph(directed=False)

vertices = {}

with file(network_filename, 'r') as f:
    for line in f:
        fr, to, confidence, flag = line.split("\t")
        if fr not in vertices:
            vertices[fr] = network.add_vertex()
        if to not in vertices:
            vertices[to] = network.add_vertex()

        e = network.add_edge(vertices[fr], vertices[to])

sfs = []
with file(sf_filename, 'r') as f:
    for line in f:
        name = line.strip()
        if name in vertices:
            sfs.append(name)

sfs_vertices = map(lambda x: vertices[x], sfs)

out = file(out_filename, 'w') if out_filename else sys.stdout

for idx, factor in enumerate(sfs_vertices):
    edge_distance = graph_tool.topology.shortest_distance(network, factor)
    for i in range(idx + 1, len(sfs_vertices)):
    	data = map(str, [sfs[idx], sfs[i], edge_distance[sfs_vertices[i]]])
        out.write( "\t".join(data) + "\n")

if out != sys.stdout:
	out.close()
