#!/usr/bin/env ruby

require 'set'
require 'gene_info'

gi = GeneInfo.for_species(GeneInfo::Human)

sf_list = File.join(File.dirname(__FILE__), '../data_aug_5/OnlyAlternativeSplicingFactors.txt')
sf = Set.new
IO.foreach(sf_list) do |line| 
	name = line.chomp.strip
	if gi.include? name
		sf << gi[name].entrez_id.to_s
	else
		$stderr.puts "Cannot map #{name}"
	end
end

raise "This script should be ran on canary as it uses local data" unless ENV['HOST'] == 'canary'

unweighted_distances_filename = '/specific/disk1/home/atiasnir/unweighted.apsp'
IO.foreach(unweighted_distances_filename) do |line| 
	from, to, distance = line.chomp.split("\t")

	next if from == to
	next unless sf.include?(from) && sf.include?(to)

	puts line
end
