#!/usr/bin/env ruby

require 'gene_info'

gi = GeneInfo.for_species(GeneInfo::Human)

ARGF.each do |line|
	entrez_str, score = line.chomp.split(/\t/)
	entrez = entrez_str.to_i if entrez_str =~ /\d+/
	name = (gi.include? entrez) ? gi[entrez].default_id : entrez_str
	puts [name, entrez_str, score].join("\t")
end	
