
filename1 <- '../rake4/sf_interactions.txt'
filename2 <- '../rake4/Tumor_lung.terminals.txt'
filename2 <- '../rake4/Tumor_colon.terminals.txt'

f1 <- read.table(filename1, sep='\t', header=F, stringsAsFactors=F)
f2 <- read.table(filename2, sep='\t', header=F, stringsAsFactors=F)

names(f1) <- c('from', 'to', 'conf','flag')
names(f2) <- c('exon')

dim(f1)
dim(f2)

m <- merge(f1, f2, by.x='to', by.y='exon')

mat <- sapply(unique(m$from), function (x)
	sapply(unique(m$from), function(y)
		   length(intersect(m$to[m$from == x], m$to[m$from == y]))))

merge(m[m$from == 'HnRNPF',], m[m$from != 'HnRNPF',], by='to', all.x=T)
heatmap(mat)
