#!/usr/bin/env ruby

require 'nokogiri'
require 'set'

@new_genes = Set.new

def handle_new_gene(xml, *names)
	names.each do |name|
		if name =~ /_\d+$/ && !@new_genes.include?(name)
			xml.nodesData {
				xml.nodeId name
				xml.operation "ADD"
			}

			@new_genes << name
		end
	end	
end

data_filename = ARGV.shift unless ARGV.empty?
output_filename = ARGV.shift unless ARGV.empty?

data_filename ||= File.join(File.dirname(__FILE__), '../data_jul_12/sf_interactions.txt') 

File.open(output_filename, 'w') do |f| 
	Nokogiri::XML::Builder.new do |xml|
		xml.BGnetworkEntity {
			xml.networkName "SFInteractions"

			IO.foreach(data_filename) do |line| 
				from, to, weight, direction = line.chomp.split(/\t/)

				handle_new_gene(xml, from, to)

				xml.edgesData {
					xml.action "SET_DIRECTED"
					xml.confidence weight
					xml.fromNodeId from
					xml.toNodeId to
				}

			end
		}
	end.doc.write_xml_to(f)
end
