import sys
import math
from graph_tool.all import *

network_filename = sys.argv[1] if (len(sys.argv) >= 2) else "human.integrated.net"

network = graph_tool.Graph(directed=True)

vertices = {}
weights = network.new_edge_property("double")

# read network from file
with file(network_filename, 'r') as f:
	for (lineno, line) in enumerate(f, start=1):
		try:
			fr, to, confidence, flag = line.split("\t")
			if fr not in vertices:
				vertices[fr] = network.add_vertex()
			if to not in vertices:
				vertices[to] = network.add_vertex()

			e = network.add_edge(vertices[fr], vertices[to])
			weights[e] = -math.log(float(confidence) * 0.999999999)

			if flag == "0":
				e = network.add_edge(vertices[to], vertices[fr])
				weights[e] = -math.log(float(confidence) * 0.999999999) 
		except:
			print "Error in line:", lineno
			raise


vertex_bw, edge_bw = graph_tool.centrality.betweenness(network, weight = weights)
bw_arr = []
for v in vertices:
	bw_arr.append((v, vertex_bw[vertices[v]]))

bw_arr = sorted(bw_arr, key=lambda x: x[1])

for name, score in bw_arr:
	print name + "\t" + str(score)
