#!/usr/bin/env ruby

require 'set'
require 'optparse'

random = 100
OptionParser.new do |opts|
	opts.banner = "Usage: #{File.basename($PROGRAM_NAME)}args"
	
	opts.on( '-r', '--random COUNT', Integer,
	         'Number of random samples') do |opt|
		random = opt
	end
end.parse!

puts "Random: #{random}"

sf_interactions_filename = ARGV.shift unless ARGV.empty?
terminals_filename = ARGV.shift unless ARGV.empty?
outfolder = ARGV.shift unless ARGV.empty?

events = Set.new
IO.foreach(sf_interactions_filename) do |line| 
	name = line.chomp.split(/\t/).first
	events << name unless name.index('_').nil?
end

terminal_count = (IO.readlines(terminals_filename).map(&:chomp).to_set & events).size

events_arr = events.to_a
tissue_name = terminals_filename.split('.').first
random.times do |i|
	random_filename = File.join(outfolder, "random_#{i}_#{tissue_name}.terminals.txt")
	File.open(random_filename, 'w') do |f| 
		f.write(events_arr.sample(terminal_count).join("\n"))
	end unless File.exists? random_filename
end

