#!/home/bnet/atiasnir/app/R/bin/Rscript

argv <- commandArgs(trailingOnly = T)
if (length(argv) > 0) {
	cancer.diff.filename <- argv[1]
	event.map.filename <- argv[2]
	output.folder <- argv[3]
} 

cancer.diff <- read.csv(cancer.diff.filename, sep="\t", header=T)
event.map <- read.csv(event.map.filename, sep="\t", header=F)

names(event.map) <- c('exon.name', 'EventName')

result <- merge(cancer.diff, event.map, by='EventName')

for(x in split(result, result$Tissue)) {
	filename <- paste(output.folder, x$Tissue[1], '.terminals.txt', sep='')
	print(filename)
	write.table(unique(x$exon.name), filename, col.names=F, row.names=F, quote=F)
}

