#!/usr/bin/env ruby

require 'set'

Threshold = 1
DefaultWeight = 0.6

filename = File.join(File.dirname(__FILE__), '../data_jun_5/doRiNA240512.txt')

interactions = Set.new
IO.foreach(filename) do |line| 
	from, to, score = line.chomp.split(/\t/).values_at(0,1,-2)
	next unless score =~ /\d+/
	interactions << [from, to, score] if score.to_i <= Threshold
end

STDERR.write( "#{interactions.size}\n")

interactions.each do |from, to|
	puts [from, to, DefaultWeight, 1].join("\t")
end	
