#!/home/bnet/atiasnir/app/R/bin/Rscript

argv <- commandArgs(trailingOnly = T)
if (length(argv) > 0) {
	control.diff.filename <- argv[1]
	event.map.filename <- argv[2]
	output.folder <- argv[3]
} else {
	control.diff.filename <- '/home/bnet/atiasnir/data/dror/data_dec_31/notCancerAS.txt'
	event.map.filename <- '/home/bnet/atiasnir/data/dror/rake/event_mapping.txt'
	output.folder <- "/vol/scratch/atiasnir/"
}

control.diff <- read.csv(control.diff.filename, sep="\t", header=T)
event.map <- read.csv(event.map.filename, sep="\t", header=F)

#control.diff <- read.csv('/home/bnet/atiasnir/data/dror/data_apr_30/cancerDiffAS.txt', sep="\t", header=T)

#event.map <- read.csv('/home/bnet/atiasnir/data/dror/data_jul_25/event_mapping.txt', sep="\t", header=F)
names(event.map) <- c('exon.name', 'eventName')

result <- merge(control.diff, event.map, by='eventName')

#network <- read.csv('/home/bnet/atiasnir/data/dror/data_jul_12/sf_interactions.txt', sep="\t", header=F)
#names(network) <- c('gene', 'exon.name', 'weight', 'direction')
#
#length(intersect(network$exon.name, result$exon.name[result$Tissue=='Tumor_lung']))

for(x in split(result, result$tissue)) {
	base.name <- gsub('/', '.', x$tissue[1])
	filename <- paste(output.folder, base.name, '.terminals.txt', sep='')
	print(filename)
	write.table(unique(union(x$exon.name, x$Gene)), filename, col.names=F, row.names=F, quote=F)
}

