#!/usr/bin/env ruby

require 'gene_info'

filename = ARGV.shift unless ARGV.empty?
filename ||= File.join(File.dirname(__FILE__), '../data_new/CLIP.txt')

mapping = GeneInfo.for_species(GeneInfo::Human)

header = true

IO.foreach(filename) do |line| 
	if header
		header = false
		next
	end

	sym1, ent1, sym2, ent2 = line.chomp.split(/\t/).first(4)

	e1 = mapping[sym1]
	e2 = nil
	if(sym2 == '-')
		e2 = mapping[ent2.to_i]
	else
		e2 = mapping[sym2]
	end

	STDERR.write("!1 #{sym1}\n") if e1.nil?
	STDERR.write("!2 #{sym2} #{ent2} \n") if e2.nil?

	next if e2.nil?

	puts [e1.entrez_id, e2.entrez_id, 0.6, 1].join("\t")
end

