#!/usr/bin/env ruby

tissue_name = ARGV.shift unless ARGV.empty?

titles = []

results = {}
first = true
IO.foreach(tissue_name) do |line| 
	if first
		titles = line.chomp.split(/\t/)
		titles.shift(2)
		first = false
	else	
		values = line.chomp.split(/\t/)
		tf, control = values.shift(2)
		results[tf] = values.map(&:to_f)
		results[tf] << (results[tf][-1] / results[tf][-4])
	end
end

#require 'debugger'; debugger

titles << "average"
random_results = Hash.new { |hash, key| hash[key] = titles.size.times.map{|a| []}}
Dir["random/random_*_#{tissue_name}"].each do |random_filename|
	first = true
	IO.foreach(random_filename) do |line| 
		if first
			first = false
		else
			values = line.chomp.split(/\t/)
			tf, control = values.shift(2)
			values.map(&:to_f).each_with_index do |val,i|
				random_results[tf][i] << val
			end
			random_results[tf][-1] << (random_results[tf][-2].last / random_results[tf][-5].last)
		end
	end
end	

def	rank(item, distr)
	pos = distr.sort.zip(1..distr.size).find {|o| o.first >= item }
	pos = pos.nil? ? distr.size : pos[1]
	pos.to_f * 100.0 / distr.size
end

puts (['anchor'] + titles.zip(['pvalue'] * titles.size)).join("\t")
results.each do |tf, values|
	puts ([tf]+ values.zip(0..(values.size-1)).map{|val, i| "#{val}\t#{"%.0f%" % rank(val, random_results[tf][i])}"}).join("\t")
end	
