#cython: boundscheck=False
#cython: wraparound=False

import numpy as np 
cimport numpy as np

np.import_array()

ctypedef np.int32_t ITYPE_t

cdef extern from "/home/bnet/atiasnir/mypy/lib/python2.7/site-packages/numpy/core/include/numpy/arrayobject.h":
    object PyArray_SearchSorted (np.ndarray, object, np.NPY_SEARCHSIDE, np.ndarray)

cimport cython
@cython.boundscheck(False) # turn of bounds-checking for entire function
@cython.wraparound(False) # turn of bounds-checking for entire function
cdef int _shuffle_edges_directed(np.ndarray[ITYPE_t, ndim=1, mode='c'] indices,
                        np.ndarray[ITYPE_t, ndim=1, mode='c'] indptr,
                        int iterations):
    cdef int u, v, s, t, ui, iv, si, it, idx
    cdef int nnz = indices.shape[0]
    cdef int switches = 0
    cdef np.ndarray[ITYPE_t, ndim=1, mode='c'] uslice, sslice
    
    for _ in range(iterations):
        iv = np.random.randint(nnz)
        # u = np.searchsorted(indptr, iv, side='right')-1
        u = PyArray_SearchSorted(indptr, iv, np.NPY_SEARCHRIGHT, np.NPY_VOID)-1
        v = indices[iv]

        it = np.random.randint(nnz)
        # s = np.searchsorted(indptr, it, side='right')-1
        s = np.PyArray_SearchSorted(indptr, it, np.NPY_SEARCHRIGHT)-1
        t = indices[it]


        if s==u or t==v:
            continue

        # check that (u,t) is not in g 
        uslice = indices[indptr[u]:indptr[u+1]]
        #idx = np.searchsorted(uslice, t)
        idx = np.PyArray_SearchSorted(uslice, t, np.NPY_SEARCHLEFT)
        if idx < indptr[u+1]-indptr[u] and indices[indptr[u] + idx] == t:
            continue

        # check that (s,v) is not in g 
        sslice = indices[indptr[s]:indptr[s+1]]
        # idx = np.searchsorted(sslice, v)
        idx = np.PyArray_SearchSorted(sslice, v, np.NPY_SEARCHLEFT)
        if idx < indptr[s+1]-indptr[s] and indices[indptr[s] + idx] == v:
            continue

        # now we have (u,v) and (s,t)
        # such that (assuming no self edges in the original graph)
        # 1. u != v != s !=t
        # 2. (u,t) not in g
        # 3. (s,v) not in g

        indices[iv] = t
        indices[it] = v

        np.PyArray_Sort(uslice, -1, np.NPY_QUICKSORT)
        np.PyArray_Sort(sslice, -1, np.NPY_QUICKSORT)
        #indices[indptr[u]:indptr[u+1]].sort()
        #indices[indptr[s]:indptr[s+1]].sort()

        switches += 1

    return switches


cdef int _shuffle_edges_undirected(np.ndarray[ITYPE_t, ndim=1, mode='c'] indices,
                        np.ndarray[ITYPE_t, ndim=1, mode='c'] indptr,
                        int iterations):
    cdef int u, v, s, t, ui, iv, si, it, idx
    cdef int nnz = indices.shape[0]
    cdef int switches = 0
    cdef np.ndarray[ITYPE_t, ndim=1, mode='c'] uslice, sslice, vslice, tslice

    for _ in range(iterations):
        iv = np.random.randint(nnz)
        #u = np.searchsorted(indptr, iv, side='right')-1
        u = np.PyArray_SearchSorted(indptr, iv, np.NPY_SEARCHRIGHT)-1
        v = indices[iv]

        it = np.random.randint(nnz)
        #s = np.searchsorted(indptr, it, side='right')-1
        s = np.PyArray_SearchSorted(indptr, it, np.NPY_SEARCHRIGHT)-1
        t = indices[it]

        if s==t or s==u or s==v or t==u or t==v:
            continue

        # check that (u,t) is not in g 
        uslice = indices[indptr[u]:indptr[u+1]]
        # idx = np.searchsorted(indices[indptr[u]:indptr[u+1]], t)
        idx = np.PyArray_SearchSorted(uslice, t, np.NPY_SEARCHLEFT)
        if idx < indptr[u+1]-indptr[u] and indices[indptr[u] + idx] == t:
            continue

        # check that (s,v) is not in g 
        sslice = indices[indptr[s]:indptr[s+1]]
        #idx = np.searchsorted(indices[indptr[s]:indptr[s+1]], v)
        idx = np.PyArray_SearchSorted(sslice, v, np.NPY_SEARCHLEFT)
        if idx < indptr[s+1]-indptr[s] and indices[indptr[s] + idx] == v:
            continue

        # now we have (u,v) and (s,t)
        # such that (assuming no self edges in the original graph)
        # 1. u != v != s !=t
        # 2. (u,t) not in g
        # 3. (s,v) not in g

        indices[iv] = t
        indices[it] = v

        np.PyArray_Sort(uslice, -1, np.NPY_QUICKSORT)
        np.PyArray_Sort(sslice, -1, np.NPY_QUICKSORT)
        #indices[indptr[u]:indptr[u+1]].sort()
        #indices[indptr[s]:indptr[s+1]].sort()

        vslice = indices[indptr[v]:indptr[v+1]]
        #ui = indptr[v] + np.searchsorted(vslice, u)
        ui = indptr[v] + np.PyArray_SearchSorted(vslice, u, np.NPY_SEARCHLEFT)
        indices[ui] = s
        np.PyArray_Sort(vslice, -1, np.NPY_QUICKSORT)
        #indices[indptr[v]:indptr[v+1]].sort()

        tslice = indices[indptr[t]:indptr[t+1]]
        #si = indptr[t] + np.searchsorted(indices[indptr[t]:indptr[t+1]], s)
        si = indptr[t] + np.PyArray_SearchSorted(tslice, s, np.NPY_SEARCHLEFT)
        indices[si] = u
        np.PyArray_Sort(tslice, -1, np.NPY_QUICKSORT)
        #indices[indptr[t]:indptr[t+1]].sort()

        switches += 1

    return switches


def degree_preserving_shuffle(g, directed=False, iterations=None):
    if g.shape[0] == 0:
        return 0

    if iterations is None:
        iterations = g.nnz * 10

    np.random.shuffle(g.data)
    if directed:
        return _shuffle_edges_directed(g.indices, g.indptr, iterations)
    else:
        return _shuffle_edges_undirected(g.indices, g.indptr, iterations)

