#!/home/bnet/atiasnir/app/R/bin/Rscript

library("org.Hs.eg.db")

argv <- commandArgs(trailingOnly = T)
if (length(argv) > 0) {
	filename <- argv[1]
} else {
	filename <- c("../rake3/Tumor_lung_scores.txt")
}

load('/home/bnet/atiasnir/data/dror/data_29_apr_2013/geneExprsLog10_Nir.RData')
tissue.data <- read.table(filename, sep="\t", header=T, col.names=c('anchor', 'control', 'max', 'mean'), stringsAsFactors=F)

conv <- as.data.frame(rbind(c("Hypothalamus (brain)", "Brain_hypothalamus"),
			 c("Lung", "Lung"), 
			 c("Tumor lung", "None"),
			 c("Testis", "Testis")),

)
names(conv) <- c("expression", "network")

# lapply(unique(tissue.data$control), function(i){
# 		subData <- tissue.data[tissue.data$control==i,];
# 		return(head(subData[order(subData$mean),]));
# 	})


symbolkeys = mappedkeys(org.Hs.egSYMBOL2EG)
aliaskeys = mappedkeys(org.Hs.egALIAS2EG)
old.name2entez <- function(x) {
	if(x %in% symbolkeys) {
		return(as.list(org.Hs.egSYMBOL2EG[x][1]))
	}

	if(x %in% aliaskeys) {
		entrez = as.list(org.Hs.egALIAS2EG[x])
		if(length(entrez) == 1) { 
			return(entrez[1])
		}
	}
	return(NaN)
}

name2entrez <- function(x) {
	retval <- rep(NaN, length(x))

	known <- x %in% symbolkeys 
	retval[known] <- sapply(as.list(org.Hs.egSYMBOL2EG[x[known]]), function(y) ifelse(length(y)>1, NaN, y[1]))

	alias.known <- ((x %in% aliaskeys) & !known)
	retval[alias.known] <- sapply(as.list(org.Hs.egALIAS2EG[x[alias.known]]), function(y) ifelse(length(y)>1, NaN, y[1]))

	return(unlist(retval))
}


keys =  mappedkeys(org.Hs.egALIAS2EG)
ged <- as.data.frame(geLog10)
#known <- rownames(ged) %in% keys
#ged$entrez <- NaN
#ged$entrez[known]<- sapply(as.list(org.Hs.egALIAS2EG[rownames(ged)[known]]), function(x) ifelse(length(x) > 1, NaN, x[1]))
ged$entrez <- name2entrez(rownames(ged))

#known <- tissue.data$anchor %in% keys
#tissue.data$entrez <- NaN
#tissue.data$entrez[known] <- sapply(as.list(org.Hs.egALIAS2EG[tissue.data$anchor[known]]), function(x) ifelse(length(x) > 1, "nir", x[1]))
tissue.data$entrez <- name2entrez(tissue.data$anchor)

tables <- apply(conv, 1, function(mapping) {
	this.results <- merge(tissue.data[tissue.data$control == mapping[2],], ged[,c("entrez",mapping[1])], by="entrez",all.x=T)
	colnames(this.results)[colnames(this.results) == mapping[1]] = "expression"
	return(this.results)
	#tissue.data$expression[tissue.data$control==mapping[2]] <<- items
})
tissue.data <- do.call(rbind,tables)
tissue.data$expression[tissue.data$entrez == NaN] <- NaN

o <- order(abs(tissue.data$expression))
o <- order(tissue.data$anchor, tissue.data$control)
ordered.tissue.data <- tissue.data[o,]

