# -*- coding: utf-8 -*-
# <nbformat>3.0</nbformat>

# <codecell>

import numpy as np

# <markdowncell>

# ###Default parameters trained using nucleosomal DNase-seq data. 
# See methods section on how parameters are trained using empirical Bayes approach

# <markdowncell>

# ***Trained using Crawford data***

# <markdowncell>

# nucleosome model

# <codecell>

crawford_nuc_a_mu = -0.0696672934205 # mean for the normal prior of a
crawford_nuc_a_sd = 0.321682945097 # standard deviation for the normal prior of a
crawford_nuc_expb = np.exp(-9.25524512331) # MLE for exp(b)
crawford_nuc_k = 0.836843209392 # MLE for k

# <markdowncell>

# parameters of different down sampling percentage

# <markdowncell>

# ***<em style="color:red">The following is only useful for doing human analysis, may not need it in the package</em>***

# <codecell>

crawford_nuc_a_mu_of_down_sampled_data = {
    0.8: -0.21813159701749385,
    0.6: -0.42529809041871475,
    0.4: -0.73746200610243606,
    0.2: -1.3308388515300709,
    0.05: -2.6836532632786012,
    0.01: -4.2828436558176062
    }

crawford_nuc_a_sd_of_down_sampled_data = {
    0.8: 0.33121367932668211,
    0.6: 0.34364861534604624,
    0.4: 0.35946097035107788,
    0.2: 0.39480464587598807,
    0.05: 0.47651532574952593,
    0.01: 0.49829607675959842
    }

crawford_nuc_expb_of_down_sampled_data = {
    0.8: np.exp(-9.3312603213780907),
    0.6: np.exp(-9.4499877075223591),
    0.4: np.exp(-9.6677494607792234),
    0.2: np.exp(-10.087440874518251),
    0.05: np.exp(-11.23458784337075),
    0.01: np.exp(-13.025817822624099)
    }


# <markdowncell>

# Background model 

# <codecell>

crawford_background_a_mu = 0.175509849829 # mean for the normal prior of a
crawford_background_a_sd = 0.602363786134 # standard deviation for the normal prior of a
crawford_background_expb = 0 # background exp(b) should be 0 because the background model is a flat curve
crawford_background_k = 0.813678886979 # MLE for k

# <markdowncell>

# ###The detrended oscillatory pattern

# <markdowncell>

# ***Crawford data***

# <codecell>

crawford_detrend_nuc_oscillation = np.array([
    -0.004968153498326,0.033400830605107,0.107720083008459,0.077924854944857,
    0.031689253480421,-0.061838993443713,-0.134886484220334,-0.145717826595095,
    -0.106683796430639,-0.068317919479062,-0.002203826771065,0.110279758148104,
    0.194741056796673,0.249304997308633,0.108267603573487,-0.044735750789797,
    -0.145894804820155,-0.182213406602459,-0.129328710320580,-0.089498268181541,
    0.012323957049297,0.095424452162763,0.226049493557192,0.293905564933306,
    0.186882034934558,-0.023505815972325,-0.103304474410308,-0.152216201539297,
    -0.159011990064728,-0.157469744214469,-0.086779546960274,0.012742006874007,
    0.183480640774290,0.231287356805134,0.250440859814150,0.064871031834204,
    -0.107757823679647,-0.148903975563454,-0.208805921494906,-0.166740585414398,
    -0.123403180486623,0.010110776592403,0.136209990531648,0.279943330696428,
    0.169693633407040,0.066284074010365,-0.017337073284965,-0.135345749132923,
    -0.232107427449176,-0.204961701087665,-0.135333201412068,0.011690943112466,
    0.112168077337376,0.193047044572055,0.413759716142915,0.202365008096292,
    0.008136274581204,-0.119697068764041,-0.169575065219243,-0.108593585835287,
    -0.040439608700539,-0.097433309095294,0.007880341308118,0.103349583777555,
    0.153930201510609,0.122816649212800,0.066376409665603,-0.078423851221311,
    -0.165252935517709,-0.141842631510070,-0.092115689260162,0.138503218628243,
    0.091394746411688,0.149217838260438,0.140144301678812,0.014246785925460,
    -0.079292196956318,-0.138234796630287,-0.056136056380131,-0.047975357183417,
    -0.060703334821220,-0.059881822076294,-0.032051854726665,0.052964707070607,
    0.019758970550970,0.057769721500153,0.033011443109988,0.023462730283660,
    -0.086311562924252,-0.118884357422079,-0.079606500730609,-0.034114650794919,
    -0.051075360304919,0.039586244986548,0.089389634134412,0.106123086524392,
    0.174817136957067,0.010327992317736,-0.104550872894549,-0.091357092260162,
    -0.143266240702793,-0.105918839513647,-0.027180770374245,-0.038066668874064,
    0.021893191556647,0.062491728432295,0.102585248773362,0.062417102419998,
    -0.030482109789152,-0.082595153497287,-0.090083031946335,-0.057474301009416,
    -0.046023438662701,-0.023811254657378,-0.011903336711608,0.020708576798777,
    0.100966991967394,0.086754297062206,0.001347721791307,-0.084101145586318,
    -0.136176991885920,-0.091409353294436,-0.051898912008900,-0.007949714988277,
    -0.006042851090444,-0.005807827388413,0.061010769521164,0.093239723704430,
    0.029545357793812,-0.040886918444011,-0.097674204757049,-0.039477332204810,
    0.000948357240923,0.002792501339430,0.030531221187639,0.036811583605823,
    0.031557357955015,0.069552636651288,0.032069090218642,0.004117797720777,
    -0.059888245867270,-0.068160081739543,-0.034022889585999,-0.007090030173167,
    0.022317671731625,-0.007844506421335,0.045182335872640
])

#
crawford_detrend_background_oscillation = np.zeros(crawford_detrend_nuc_oscillation.shape) 

# <markdowncell>

# ###Other parameters used

# <markdowncell>

# ***genome size***

# <codecell>

hg18_sizes = {'chr1':247249719, 'chr2':242951149, 'chr3':199501827, 
                'chr4':191273063, 'chr5':180857866, 'chr6':170899992, 
                'chr7':158821424, 'chrX':154913754, 'chr8':146274826,
                'chr9':140273252, 'chr10':135374737, 'chr11':134452384, 
                'chr12':132349534, 'chr13':114142980, 'chr14':106368585,
                'chr15':100338915, 'chr16':88827254, 'chr17':78774742, 
                'chr18':76117153, 'chr19':63811651, 'chr20':62435964, 
                'chrY':57772954, 'chr22':49691432, 'chr21':46944323, 
                'chr6_cox_hap1':4731698,'chr6_qbl_hap2':4565931, 
                'chr17_random':2617613, 'chr6_random':1875562, 
                'chr5_h2_hap1':1794870, 'chrX_random':1719168, 
                'chr21_random':1679693, 'chr1_random':1663265, 
                'chr9_random':1146434, 'chr8_random':943810, 
                'chr4_random':842648, 'chr15_random':784346, 
                'chr3_random':749256, 'chr7_random':549659, 
                'chr19_random':301858, 'chr22_random':257318, 
                'chr11_random':215294, 'chr13_random':186858, 
                'chr2_random':185571, 'chr5_random':143687, 
                'chr10_random':113275, 'chr16_random':105485,
                'chr22_h2_hap1':63661, 'chrM':16571, 'chr18_random':4262}

sacCer2_sizes = {'chr1':230208, 'chr2':813178, 'chr3':316617, 
                'chr4':1531919, 'chr5':576869, 'chr6':270148, 
                'chr7':1090947, 'chr8':562643, 'chr9':439885, 
                'chr10':745742, 'chr11':666454, 'chr12':1078175, 
                'chr13':924429, 'chr14':784333, 'chr15':1091289, 
                'chr16':948062}

