function plot_height_vs_height(abundances, specification, fig)

% Colors
blue = [0 68 252]/256;
red = [252 34 13]/256;
tan = [253 158 65]/256;
green = [24 140 18]/256;
black = [0 0 0]/256;
gray = [145 145 145]/256;

% Verify information
assert(strcmp('height_vs_height', specification{1}))

% Get list of samples. Man this is awkward
sample_names = specification{2};
num_samples = numel(sample_names);
samples = zeros(num_samples,1);
descriptions = {};
for n = 1:num_samples
    sample_found = false;
    for m=1:numel(abundances)
        if strcmp(abundances(m).name,sample_names(n))
            samples(n,1) = m;
            sample_found = true;
        end
    end
    if ~sample_found
        disp(['Error: cannot find data for ' sample_names(n)]);
        assert(false);
    end
end
assert(num_samples == numel(samples))
assert(num_samples >= 2)

% Create plot names
experiments = {};
batches = {};
for n=1:num_samples
    experiments{n} = sample_names{n}(2:end);
    batches{n} = sample_names{n}(1);
end
experiments = unique(experiments);
batches = unique(batches);
plot_name = [horzcat(experiments{:}) '_' horzcat(batches{:})];
plot_title = [horzcat(experiments{:}) ' ' horzcat(batches{:})];

% Determine min_width and max_height
these_abundances = abundances(samples);
for n=1:numel(these_abundances)
    min_heights(n) = these_abundances(n).min_height;
    max_widths(n) = these_abundances(n).max_width;
end

% Make sure min_width and max_heights are the same across samples
%assert(min(min_heights) == max(min_heights))
%assert(min(max_widths) == max(max_widths))
min_height = 0; %min_heights(1);
max_width = max_widths(1);

% Get colors. Default to those in specification. If none there, use
% those in annotation. 
assert(numel(specification) == 3)
assert(numel(specification{3}) == num_samples-1)
for n=2:num_samples
    descriptions{n,1} = these_abundances(n).description;
    colors(n,:) = specification{3}{n-1};
end

% Create figure
figure(fig)
clf
set(gca, 'fontsize', 16, 'box', 'on', 'linewidth', 2)
xyl = [.01 2.0]; 
xyticks = [.01, .1, 1];
loglog(xyl, xyl, 'color', gray, 'linestyle', '--', 'linewidth', 2);
hold on

% Get information on reference peaks
ref_widths = these_abundances(1).peak_fwhms/1000;
ref_heights = these_abundances(1).peak_heights;
ref_arss = these_abundances(1).peak_arss;
hs = [];
rhos = [];
legends = {};
for n=2:num_samples
    
    % Get information on mutant peaks
    mut_widths = these_abundances(n).peak_fwhms/1000;
    mut_heights = these_abundances(n).peak_heights;
    mut_arss = these_abundances(n).peak_arss;
    
    ref_is = [];
    mut_is = [];
    
    for k=1:numel(ref_arss)
        index = strmatch(ref_arss{k}, mut_arss, 'exact');
        if numel(index) == 1 && mut_heights(index)>=min_height && ref_heights(k)>=min_height
            ref_is(end+1) = k;
            mut_is(end+1) = index;
        end
    end
    if numel(ref_is) == 0 
        disp(['Error: nothing to plot in ' plot_name '. Moving on...'])
        return % Abort this plot
    end
    
    % Compute normalization factor using top half of peaks
    mut_factor = quantile(mut_heights,0.9);
    ref_factor = quantile(ref_heights,0.9);
    
    hs(n-1) = loglog(ref_heights(ref_is)/ref_factor, mut_heights(mut_is)/mut_factor, '.','MarkerEdgeColor', colors(n,:),'MarkerFaceColor', 'none', 'markersize', 24, 'linewidth', 2);
    x = ref_heights(ref_is);
    y = mut_heights(mut_is);
    X = [x(:), y(:)];
    rmat = corr(X);
    r = rmat(1,2);
    disp('=====')
    disp([plot_name ': R == ' num2str(r)])
    disp([plot_name ' height vs height sample ' num2str(n) ': ' num2str(numel(ref_is)) ' data points'])
    %disp(['reference width:  ' num2str(mean(ref_widths(ref_is))) ' +- ' num2str(std(ref_widths(ref_is)))])
    %disp(['mutant width:     ' num2str(mean(mut_widths(mut_is))) ' +- ' num2str(std(mut_widths(mut_is)))])
    disp('')
    
    legends{n-1} = descriptions{n};
    
    % If want to display correlations: Compute spearman rank correlation
    %rhos(n-1) = corr(ref_widths(ref_is)', mut_widths(mut_is)', 'type', 'spearman');
    %legends{n-1} = [descriptions{n},  ': ',  num2str(rhos(n-1), '%.2f')];
    
end
axis square

set(gca, 'box', 'on', 'linewidth', 3, 'fontsize', 30, 'xlim', xyl, 'ylim', xyl, 'xtick', xyticks, 'ytick', xyticks);
xlabel([descriptions{1} 'reference peak height (au)'])
ylabel('mutant peak height (au)','fontsize', 30)
legend(hs, legends, 'location', 'northoutside', 'fontsize', 12)
title({plot_title,''}, 'fontsize', 30)

% Save plot
plot_file_name = ['results/plots_height_vs_height/height_vs_height_' plot_name];
%saveas(gcf,[plot_file_name '.eps'],'epsc');
print('-dpng','-r300',plot_file_name)
