/* program to recover selected regions of .znt files */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int,char *[]);

FILE *fTmReadp;

static char chrZntFn[100] = "";
static char znt[10] = ".znt";

main (int argc,char *argv[])
{

	int n, bbase;
	int linPtr;
	long int chrStart, chrEnd, chrLen, pos;
	char chrSet[20];
	
	n = 0;
	bbase = 0;
	linPtr = 0;
	chrStart = 0;
	chrEnd = 0;
	chrLen = 0;
	pos = 0;
	
	if(argc != 4)
		{
		printf("argc %d; syntax toTest chr chrStart chrEnd\n");
		exit(0);
		}

	strcpy(chrSet,argv[1]);

	strcpy(chrZntFn,chrSet);
	strcat(chrZntFn,znt);
	
	chrStart = atol(argv[2]);
	chrEnd = atol(argv[3]);

	fTmReadp = fopen(chrZntFn,"rb");
		if (fTmReadp == NULL)
		{
		printf("chrZntFn rb test command failed.\n");
		exit(0);
		}
	fseek(fTmReadp,0,2);
	chrLen = ftell(fTmReadp);

	/* recover and print gene region */

	printf(">%s\n",chrZntFn);

	fseek(fTmReadp,chrStart - 1,0);
	pos = ftell(fTmReadp);
	do
		{
		bbase = getc(fTmReadp);
		printf("%d",bbase);
		if(bbase >= 10)
			{
			linPtr = linPtr + 2;
			}
		else
			{
			linPtr++;
			}
		if (linPtr >= 60)
			{
			printf("\n");
			linPtr = 0;
			}
		n++;
		pos++;
		}while(n < chrEnd - chrStart && !feof(fTmReadp) && pos < chrLen);

	if(linPtr)
		{
		printf("\n");
		}
	
	fclose(fTmReadp);

	return 0;
}
