#!/usr/bin/perl -w

$| = 1;

use POSIX;
use Sort::Naturally;

if (-e "6456_disinfected.SVs") {
    open (DISINFECTED, "6456_disinfected.SVs") || print "\tcannot read 6456_disinfected.SVs\n";
    while (<DISINFECTED>) {
        if (/\w/) {
            chomp;
            @tabs = split /\t/;
            $clean{$tabs[0]} = 1;
        }
    }
    close DISINFECTED;
}

$bed = "conchie.flt.NOV13";
open (CONCHIE_ANNOTATED, "$bed.mod.anno") || print "\tcannot read $bed.mod.anno\n";
while (<CONCHIE_ANNOTATED>) {
    if (/\w/) {
        chomp;
        @tabs = split /\t/;
        if (defined $clean{$tabs[3]} && ($tabs[4] eq 'Ji' || $tabs[4] eq 'Opie') && $tabs[5] =~ /prime/) {
            $x{$tabs[0]}{$tabs[4]}{$tabs[6]} = 1;
            $spuriosity{$tabs[0]}{$tabs[4]}{$tabs[5]}{SVs}{$tabs[3]} = 1;
            $spuriosity{$tabs[0]}{$tabs[4]}{$tabs[5]}{bins}{$tabs[6]} = 1;
        }
    }
}
close CONCHIE_ANNOTATED;
print keys(%x) . " siRNAs\n";
foreach $siRNA (keys %x) {
    if (keys(%{$x{$siRNA}}) == 2) {
        $siRNA =~ /B73siRNA_(\d+)_\d+\-(\d+)/;
        $len = $1;
        foreach $sourcefam (keys %{$x{$siRNA}}) {
            foreach $region (keys %{$spuriosity{$siRNA}{$sourcefam}}) {
                if (keys(%{$spuriosity{$siRNA}{$sourcefam}{$region}{SVs}}) <= 1) {
                    foreach $banbin (keys %{$spuriosity{$siRNA}{$sourcefam}{$region}{bins}}) {
                        $bansbins{$banbin} = 1;
                    }
                }
            }
            foreach $sbin (keys %{$x{$siRNA}{$sourcefam}}) {
                unless (defined $bansbins{$sbin}) {
                    $sbins{$sbin} = 1;
                }
            }
            foreach $targetfam (keys %{$x{$siRNA}}) {
                unless (defined $done{$targetfam}{$sourcefam}) {
                    $done{$sourcefam}{$targetfam} = 1;
                    foreach $region (keys %{$spuriosity{$siRNA}{$targetfam}}) {
                        if (keys(%{$spuriosity{$siRNA}{$targetfam}{$region}{SVs}}) <= 1) {
                            foreach $banbin (keys %{$spuriosity{$siRNA}{$targetfam}{$region}{bins}}) {
                                $bantbins{$banbin} = 1;
                            }
                        }
                    }
                    foreach $tbin (keys %{$x{$siRNA}{$targetfam}}) {
                        unless (defined $bantbins{$tbin}) {
                            $tbins{$tbin} = 1;
                        }
                    }
                    foreach $sbin (keys %sbins) {
                        foreach $tbin (keys %tbins) {
                            unless ($sourcefam eq $targetfam && (abs($sbin-$tbin) <= 10 || ($sbin <= 100 && $tbin <= 100) || ($sbin > 200 && $tbin > 200) || ($sbin <= 100 && $tbin > 200) || ($sbin > 200 && $tbin <= 100) || ($sbin >= 100 && $tbin >= 100 && $sbin < 200 && $tbin < 200))) {
                                $st{$sourcefam}{$sbin}{$targetfam}{$tbin}{$len}{species} += 1;
                            }
                        }
                    }
                    undef %tbins;
                    undef %bantbins;
                }
            }
            undef %sbins;
            undef %bansbins;
        }
        undef %done;
    }
}
$id = 0;
foreach $sfam (sort keys %st) {
    foreach $sbin (sort {$a<=>$b} keys %{$st{$sfam}}) {
        foreach $tfam (sort keys %{$st{$sfam}{$sbin}}) {
            foreach $tbin (sort {$a<=>$b} keys %{$st{$sfam}{$sbin}{$tfam}}) {
                foreach $len (sort keys %{$st{$sfam}{$sbin}{$tfam}{$tbin}}) {
                    $heat = $st{$sfam}{$sbin}{$tfam}{$tbin}{$len}{species};
                    if ($heat > 0) {
                        $z = 0;
                        if ($heat >= 50) {
                            $colour = 'red_a5';
                            $stroke_colour = 'red_a5';
                            $z = '3';
                        } elsif ($heat >= 25) {
                            $colour = 'orange_a5';
                            $stroke_colour = 'orange_a5';
                            $z = '2';
                        } elsif ($heat >= 10) {
                            $colour = 'green_a5';
                            $stroke_colour = 'green_a5';
                            $z = '1';
                        } elsif ($heat > 0) {
                            $colour = 'blue_a5';
                            $stroke_colour = 'blue_a5';
                            $z = '0';
                        }
                        $from = ($sbin-1) * 10;
                        $to = ($sbin * 10) - 1;
                        $links{"$filetag"} .= "id$id $sfam $from $to color=$colour,z=$z,stroke_color=$stroke_colour,stroke_thickness=1,flat=1\n";
                        $from = ($tbin-1) * 10;
                        $to = ($tbin * 10) - 1;
                        $links{"$filetag"} .= "id$id $tfam $from $to color=$colour,z=$z,stroke_color=$stroke_colour,stroke_thickness=1,flat=1\n";
                        ++$id;
                    }
                }
            }
        }
    }
}
open (CIRCOS, ">MASiVE--epipipe-circos.sh") || print "\tcannot create batch\n";
foreach $linktype (keys %links) {
    open (LINKS, ">$linktype.epipipe-circos.links") || print "\tcannot create links\n";
    print LINKS $links{$linktype};
    close LINKS;

    open (CONF, ">$linktype.epipipe-circos.conf") || print "\tcannot create conf\n";
    print CONF "
<colors>
<<include /labs/bat/projects/toolshed/circoletto/www/cleaned_up/conf4offline/colors.conf>>
</colors>

<fonts>
<<include /labs/bat/projects/toolshed/circoletto/www/cleaned_up/conf4offline/fonts.conf>>
</fonts>

<<include /labs/bat/projects/masive/data/MASiVE--epipipe-circos.ideogram>>
<<include /labs/bat/projects/masive/data/MASiVE--epipipe-circos.ticks>>

<<include /labs/bat/projects/toolshed/circoletto/www/cleaned_up/conf4offline/housekeeping.conf>>

#karyotype   = /labs/bat/projects/masive/data/MASiVE--epipipe-circos.karyotype
karyotype   = /labs/bat/projects/masive/data/MASiVE--epipipe-circos.karyotype.JiOpie

<image>
dir  = /labs/bat/projects/masive/data
file = $linktype.epipipe-circos.png
# radius of inscribed circle in image
radius         = 750p
background     = white
# by default angle=0 is at 3 o'clock position
angle_offset   = -88
24bit=yes
auto_alpha_colors = yes
auto_alpha_steps  = 5
</image>

chromosomes_units = 1
chromosomes_display_default = yes
#chromosomes_order = Ji,Opie,Jienv,Giepum,Hopie
chromosomes_order = Ji,Opie
#chromosomes_radius = comp60311_c0_seq1:0.92r;comp60311_c0_seq2:0.92r

<links>
radius1               = 0.99r
radius2               = 0.99r
crest                 = 0.1
ribbon                = yes
# stroke_color          = vdgrey
# stroke_thickness      = 1
<link sirnax>
show         = yes
file         = /labs/bat/projects/masive/data/$linktype.epipipe-circos.links
#record_limit = 9000

<rules>
# intrachromosomal links with ends within x dist placed outside circle
<rule>
importance = 90
#condition  = _CHR1_ eq _CHR2_ && abs(_START1_-_START2_) < 1000
condition  = _CHR1_ eq _CHR2_
radius1       = 1r+5p
radius2       = 1r+5p
radius        = 1r+200p
bezier_radius = 1r+250p
crest         = 0.5
#color         = red
</rule>
## all other intrachromosomeal links hidden
#
#<rule>
#importance = 80
#condition  = _CHR1_ eq _CHR2_
#show       = no
#</rule>
## all remaining links are hidden
#<rule>
#importance = 10
#condition  = 1
#show       = no
#</rule>
</rules>

</link>
</links>


#<plots>
#<plot>
#type    = histogram
#file    = /labs/bat/www/tools/results/circoletto/xlf_bm.blast00077231091.his
#extend_bin = no
#color      = white
#fill_color = red,orange,green,blue
#fill_under = yes
#thickness  = 0,0,0,0
#min     = 0
#r0      = 1.015r
#r1      = 1.092r
#<axes>
#<axis>
#color = lgrey
#thickness = 1
#spacing = 1
#</axis>
#</axes>
#</plot>
#</plots>
";
    close CONF;
    print CIRCOS "circos -silent -conf $linktype.epipipe-circos.conf\n";
    `circos -silent -conf $linktype.conf`;
}
close CIRCOS;

exit;
