#-- Create the Binned data for JCA . 
cd  /jolidisk/users/ballester/mechali/data/jc_andrau/JVH_BB/ES_dataset/Mnase/raw/

#-- Concatenate input
cd ~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/Input/raw 
cat rep1/s_5.bed  rep1/s_5.bed  | sortBed > input.bed

#-- Concatenate Pol2
cd ~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/PolII/raw
cat rep1/s_2.bed rep2/s_3.bed  > pol2.bed 


#-- Macs peaks 
macs_bed="/jolidisk/users/ballester/mechali/analysis/final_peaks/concat_MACS_merged300bp.bed"
macs_bed_kmeans="/jolidisk/users/ballester/mechali/analysis/final_heatmap/concat_MACS_merged300bp_kmeans_13_ordered2.bed" 


#-- Marks to bin
mnase="/jolidisk/users/ballester/mechali/data/jc_andrau/JVH_BB/ES_dataset/Mnase/raw/merged.bed"
input="/jolidisk/users/ballester/mechali/data/jc_andrau/JVH_BB/ES_dataset/Input/raw/input.bed"
pol2="/jolidisk/users/ballester/mechali/data/jc_andrau/JVH_BB/ES_dataset/PolII/raw/pol2.bed"

#-- Parameters 
#was win=100 l=5000
win="25"
l="1000"



cd ~/jmechali/analysis/final_heatmap

#-- This has the order of the original BED
./hm_generic2.pl $macs_bed  $mnase  $win $l $input > $mnase.bin_inputcorrected2


#-- This has the order of the kmeans order
./hm_generic2.pl $macs_bed_kmeans  $mnase  $win $l $input > $mnase.bin.k13ordered_inputcorrected2
./hm_generic2.pl $macs_bed_kmeans  $mnase  $win $l  > $mnase.bin.k13ordered2


#-- POL2 This has the order of the original BED
#./hm_generic2.pl $macs_bed  $pol2  $win $l $input > $pol2.bin_inputcorrected2
#./hm_generic2.pl $macs_bed  $pol2  $win $l  > $pol2.bin


#-- POL2 This has the order of the kmeans order
./hm_generic2.pl $macs_bed_kmeans  $pol2  $win $l $input > $pol2.bin.k13ordered_inputcorrected2
./hm_generic2.pl $macs_bed_kmeans  $pol2  $win $l  > $pol2.bin.k13ordered2





##############################
#--R
##############################
cd ~/jmechali/analysis/final_heatmap/jca 

R
library(RColorBrewer)
library(gplots)
col1 = colorRampPalette(brewer.pal(9,"Reds"))(20)


#--------------------------
#-- Raw MNASE 
#--------------------------
mnase = read.table("~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/Mnase/raw/merged.bed.bin.k13ordered")
#-- Remove outliers
xm=mnase[,5:105]
#xm[xm   < 0] = 0
q95m  =quantile(as.matrix(xm),  probs=.95)
xm[xm > q95m] = q95m

tiff("mnase_MACS_kmeans13.tiff", width=450, height=1200) 
image(t(as.matrix(xm[,1:101])),   col = col1, main="MNASE", axes = FALSE)
dev.off()


#------------------------
#-- MNASE Input corrected 
#------------------------
mnase = read.table("~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/Mnase/raw/merged.bed.bin.k13ordered_inputcorrected")
#-- Remove outliers
xm=mnase[,5:105]
xm[xm   < 0] = 0
q95m  =quantile(as.matrix(xm),  probs=.95)
xm[xm > q95m] = q95m

tiff("mnase_inputcorrected_MACS_kmeans13.tiff", width=450, height=1200) 
image(t(as.matrix(xm[,1:101])),   col = col1, main="MNASE input corrected", axes = FALSE)
dev.off()


#--------------------------
#-- Raw POL2 
#--------------------------
pol2 = read.table("~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/PolII/raw/pol2.bed.bin.k13ordered")
#-- Remove outliers
xm=pol2[,5:105]
#xm[xm   < 0] = 0
q95m  =quantile(as.matrix(xm),  probs=.95)
xm[xm > q95m] = q95m

tiff("pol2_MACS_kmeans13.tiff", width=450, height=1200) 
image(t(as.matrix(xm[,1:101])),   col = col1, main="POL2", axes = FALSE)
dev.off()


#------------------------
#-- POL2 Input corrected 
#------------------------
pol2 = read.table("~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/PolII/raw/pol2.bed.bin.k13ordered_inputcorrected")
#-- Remove outliers
xm=pol2[,5:105]
xm[xm   < 0] = 0
q95m  =quantile(as.matrix(xm),  probs=.95)
xm[xm > q95m] = q95m

tiff("pol2_inputcorrected_MACS_kmeans13.tiff", width=450, height=1200) 
image(t(as.matrix(xm[,1:101])),   col = col1, main="POL2 input corrected", axes = FALSE)
dev.off()






############################## 1kb 25bp bins
############################################################
#--R
############################################################
############################## 1kb 25bp bins 
cd ~/jmechali/analysis/final_heatmap/jca 


R
library(RColorBrewer)
library(gplots)
col1 = colorRampPalette(brewer.pal(9,"Reds"))(20)


#--------------------------
#-- Raw MNASE 
#--------------------------
mnase = read.table("~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/Mnase/raw/merged.bed.bin.k13ordered2")
#-- Remove outliers
xm=mnase[,5:85]
#xm[xm   < 0] = 0
q95m  =quantile(as.matrix(xm),  probs=.95)
xm[xm > q95m] = q95m

tiff("mnase_MACS_kmeans13_1kb.tiff", width=450, height=1200) 
image(t(as.matrix(xm[,1:81])),   col = col1, main="MNASE", axes = FALSE)
dev.off()


#------------------------
#-- MNASE Input corrected 
#------------------------
mnase = read.table("~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/Mnase/raw/merged.bed.bin.k13ordered_inputcorrected2")
#-- Remove outliers
xm=mnase[,5:85]
xm[xm   < 0] = 0
q95m  =quantile(as.matrix(xm),  probs=.95)
xm[xm > q95m] = q95m

tiff("mnase_inputcorrected_MACS_kmeans13_1kb.tiff", width=450, height=1200) 
image(t(as.matrix(xm[,1:81])),   col = col1, main="MNASE input corrected", axes = FALSE)
dev.off()


#--------------------------
#-- Raw POL2 
#--------------------------
pol2 = read.table("~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/PolII/raw/pol2.bed.bin.k13ordered2")
#-- Remove outliers
xm=pol2[,5:85]
#xm[xm   < 0] = 0
q95m  =quantile(as.matrix(xm),  probs=.95)
xm[xm > q95m] = q95m

tiff("pol2_MACS_kmeans13_1kb.tiff", width=450, height=1200) 
image(t(as.matrix(xm[,1:81])),   col = col1, main="POL2", axes = FALSE)
dev.off()


#------------------------
#-- POL2 Input corrected 
#------------------------
pol2 = read.table("~/jmechali/data/jc_andrau/JVH_BB/ES_dataset/PolII/raw/pol2.bed.bin.k13ordered_inputcorrected2")
#-- Remove outliers
xm=pol2[,5:85]
xm[xm   < 0] = 0
q95m  =quantile(as.matrix(xm),  probs=.95)
xm[xm > q95m] = q95m

tiff("pol2_inputcorrected_MACS_kmeans13_1kb.tiff", width=450, height=1200) 
image(t(as.matrix(xm[,1:81])),   col = col1, main="POL2 input corrected", axes = FALSE)
dev.off()

















