cluster.density.profiles <-function(density.table, 
	k, 
	outfile, 
	peak.threshold=1e-9, 
	quantile.cutoff=0.99, 
	permut=FALSE, 
	create.subdir=TRUE, 
	sort.criterion="sum",
	show.pvalue=FALSE)	{

## permut = permut random all lines
## create.subdir = create repertory for output files
## sort.criterion = 1 or 2 for sort.criterion the cluster with mean or not
## peak.threshold = prob use for select the interval use for choice the peak
## show.p-value = show the p-values for select the peak.threshold if default value is not good

  ################################################################################
  ## output parameter files
  ##

  dir.main <- getwd()
  number.cluster <- k

  dir.results <- dir.main
  dir.figures <- dir.main

  filename <- paste(outfile,k,peak.threshold, sep='_')

  if(create.subdir == TRUE){
	dir.main <- file.path(dir.main, 'cluster_density_profiles')
	dir.figures <- file.path(dir.main,'figures')
	dir.results <- file.path(dir.main,'results')
 	
	## Create file if required
	dir.create(dir.figures, showWarnings=FALSE, recurs=TRUE)
	dir.create(dir.results, showWarnings=FALSE, recurs=TRUE)

	print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),'...Output directory create'))
	
	}

  ## #############################################################################
  ## Prepares data for k-means

  density.profile <- as.matrix(density.table[,5:dim(density.table)[2]])

  ##-- Add 0 if negative values 
  density.profile[density.profile < 0] <- 0

  ##-- Compute quatile value to normalize outliers (threshold) and replace outliers with qantule values (quantile.cutoff
  cutoff.value <- quantile(density.profile, probs= quantile.cutoff)
  density.profile[density.profile > cutoff.value ] <- cutoff.value
  nbr.col <- ncol(density.profile)

  print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),'...Data clean'))

  ## #############################################################################
  ## Use Permate function to programs test
  ##
  

  while(permut==TRUE){
    print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),'...Permuting data'))
    for(i in 1:nrow(density.profile)) {
      filename <- 'permute'
      density.profile[i,]=sample(c(density.profile[i,]),dim(density.profile)[2])	}
    permut <- FALSE
    print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),'...End of permuting'))
  	}

  ## #############################################################################
  ## K-means 
  ##

   print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),"...k-mean's begining"))

  ## Parameters to k-means
  number.iteration <- 1000

  ## Run KMEANS with sample or all data
  density.profile.kmean <- kmeans(density.profile, k ,iter.max=number.iteration) ## With all data

  ## Save the kmeans clustering - this will become the original k order
  official.kmean.result  <- density.profile.kmean  

  print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),"...k-mean's end"))

  ## #############################################################################
  ## Smothing and found the order to cluster means
  ##

   print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),"...cluster's ordering"))

  ## Parameters of runmed
  means.cluster <- as.matrix(density.profile.kmean$centers) ## create matrix with means for hierarchic cluster
  reader.windows <- 2

  ## smoothing and score calculate
  valeur <- c() #score for each cluster
  g <- 1
  for(i in 1:k){
    smoothing.means.means<- runmean(means.cluster[i,], k=reader.windows) 
    j=turnpoints(smoothing.means.means)
    score <- 0
    list.tp <- as.vector(extract(j,no.tp=0, peak=1,pit=-1))
    score.tp <- as.vector(j$proba)
    a <- 1
    b <- 1
    c <- 0
    seuil <- peak.threshold
    for(k in list.tp){
      if(k ==-1){ 
        b <- b+1	}
      if(k == 1){ 
        if( (score.tp[b]) < (seuil)) {
          c <- c + 1 
          score <- score+a	}
        b <- b+1	}
      a <- a+1	}
    
    if(show.pvalue == TRUE){
	print(order(score.tp))	}
	
    if( sort.criterion == "mean"){
	    valeur[g] <- score/c   }
    if( sort.criterion == "sum"){
	    valeur[g] <- score   }
    g <- g+1	}

  couple.score.cluster <-as.matrix(valeur) #matrix with each cluster and score
  order.couple <- order(couple.score.cluster) # matrix order desc

  ## #############################################################################
  ## Order the reads into the cluster means
  ##kmean

  print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),"... order cluster"))
  k <- number.cluster
  kmean.data <- data.frame(density.profile, density.profile.kmean$cluster)
  kmean.data <- as.matrix(kmean.data)
  output <- data.frame(density.table, density.profile.kmean$cluster)

  ## Other method to order
  order.couple <- rev(order.couple)

  #output <- as.matrix(output)
  resultat <- unlist(sapply(order.couple,function(x)res <- which(output[,ncol(output)]==x))) 
  output <- output[resultat,]

  ## Order the profiles
  resultat <- unlist(sapply(order.couple,function(x)res <- which(kmean.data[,ncol(kmean.data)]==x)))
  kmean.data <- kmean.data[resultat,]
  output <- cbind(output[,1:4],output[,dim(output)[2]],output[,5:(dim(output)[2]-1)])

  order.couple <- rev(order.couple)

  ## #############################################################################
  ## Output File
  ##

  ## Text file matrice
  print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),"... Write data bins3"))
  text.name <- paste(filename,'.bins3')
  text.name <- file.path(dir.results,text.name)
  write.table(output, file=text.name, quote=FALSE ,row.names = FALSE , col.names = FALSE )

  ## Heatmap 
  print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),"... Draw heatmap"))
  out <- paste(filename,'_heatmap.tiff')

  out <- file.path(dir.results,out)

  x <- 600
  y <- 1500
  tiff(out, width=(x/2), height=y)

  col_mmus = colorRampPalette(brewer.pal(9,"Reds"))(20)
  title_mmus=paste("heatmap",filename, "k=", k, sep=" ")
  maxcol=dim(kmean.data)[2]-1  
  image(t(kmean.data[,1:maxcol]),  col = col_mmus, main=title_mmus, axes = FALSE)
  #axis(1, at=c(seq(0, 1, length.out=8)),lab=c(seq(-10, 10, length.out=8) ) )

  dev.off()

  ## Graphe outfile
  print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),"... Draw graphe"))
  vector <- c(1:k)

  out <- paste(filename,'_graphe.png')

  out <- file.path(dir.figures,out)

  png(out, width = x, height= y )
  
  matx.windows <- matrix(c(replicate(k,1),replicate(k, 2),c(3:(k+2))),ncol=3,nrow=k)
  
  layout(matx.windows)

  ## First part
  col_mmus = colorRampPalette(brewer.pal(9,"Reds"))(20)
  title_mmus=paste("heatmap",filename, "k=", k, sep=" ")
  maxcol=dim(kmean.data)[2]-1  
  image(t(kmean.data[,1:maxcol]),  col = col_mmus, main=title_mmus, axes = FALSE)
  #axis(1, at=c(seq(0, 1, length.out=8)),lab=c(seq(-10, 10, length.out=8) ) )

  ## Second part
  len <- official.kmean.result$size

  size.rect <- c()
  for(i in 1:length(order.couple)){
	size.rect[i] <- len[order.couple[i]]
	i <- i+1
	}

  colors=sample(c(colors()),k)
  
  par(mai=c(0,0,0,0))
  plot( 0, 0, xlim=c(0,(x/3)), ylim=c(0,y), xlab="", ylab="", axes=FALSE, type='n')
 
  localisation <- y 
  loca <- y
  n.detail <- k/2
  for(i in 1:k){

	taille <- (size.rect[i]/sum(size.rect))*y
	loc <- localisation - (taille / 2 )

	taille.loc <- ((1/k)*y)
	graphe.loc <- loca - (taille.loc / 2)
	loca <- loca - taille.loc 

        graphe.loc <- graphe.loc + ( (n.detail/k)*taille.loc)

	lines(c(0,0),c(localisation,(localisation-taille)),lwd=10,col=colors[i])
	
	text((0.02*x),loc,paste(order.couple[i]),cex=2, col='black')
	
	lines(c((0.03*x),((x/3)-0.03*x)),c(loc,graphe.loc),lwd=3,col=colors[i])
  	
	localisation <- localisation - taille
	n.detail <- n.detail - 1
	}

  ## Third part
  par(mai=c(0,0,0,0))

  for(i in order.couple){
    plot(means.cluster[i,],xlim=c(0,nbr.col),ylim=c(0,cutoff.value),type='l',col='red') }
  
  dev.off()

  print(paste(format(Sys.time(), "%m/%d/%Y %H:%M:%S"),"... Done"))

}
