\name{cluster.density.profiles}
\alias{cluster.density.profiles}
\Rdversion{1.1}

\title{Clustering and order density profiles}

\description{ This function uses a data.frame (table) to make clusters with
	k-means and order the clusters found. There are 3 output files :
	a Heatmap shows the clusters ordered by this function, 
	a table that includes the class number
	and a figure that links the heatmap classes to each mean density profile
	}

\usage{cluster.density.profiles(density.table, k, peak.threshold=0.95, outfile, permut = FALSE, create.subd-ir = TRUE, sort.criterion = 1)}

\arguments{
  \item{density.table}{its a matrix forma data.frame with the number of reads.
		
}
  \item{k}{== int() number of clusters. This argument is passed to the kmeans() function.
}

  \item{quantile.cutoff}{it's the prob use for a quantile selection for minimize the upper score in the data.frame density.table.
}

  \item{peak.threshold}{peak.threshold == int() , it's the limit for select the probability of Student's test to select the peak of means density profiles. By default its 0.95 value.
}
  \item{outfile}{== str() , it's the name for the files output.
}
  \item{permut}{== TRUE or FALSE, it's for use a random sample data.
}
  \item{create.subdir}{== TRUE or FALSE. If true, the program
    automatically creates a directory to store the output files. 
}
  \item{sort.criterion}{== "sum" (default) or "mean": choice for sorting the clusters. First it's simple method to range the cluster with a score. Second it's to order with means score.
}
  \item{show.p-value}{== TRUE (default) or FALSE : its a value used to show the p-value for each mean density profils.
}

}


\details{}

\value{heatmap : An image of all the rows of the matrices stored.

	output : Its the same data.frame who used in arguments with the addition a column for the cluster in the description column.

	graphe : heatmap associated to the density profile means }

\references{TAGC Laboratory}

\author{Quentin Barbier}

\note{This algorithme its use for order the reads profile density to DNA}


\seealso{Origin Replication}

\examples{

table <- load.density.table("cdpRpackage/data/data_test.bins")

cluster.density.profiles(density.table=table,k=16,outfile='toto')

}
\keyword{ cluster }
\keyword{ kmeans }
