#!usr/bin/perl
use strict;
use warnings;

# requires bedtools. prints the overlap between between peaks

my $lad = shift; # Peak 1
my $gad = shift; # Peak 2

my $jac_out = qx(bedtools jaccard -a $lad -b $gad);
my @jacs = split(/\s+/, $jac_out);
my $count = pop(@jacs);
my $jac_index = pop(@jacs);
my $union = pop(@jacs);
my $ints = pop(@jacs);

my $lad_total;
my $gad_total;

open (LADS, $lad) || die "Cannot open $lad $!\n";

while (my $line = <LADS>) {
	chomp($line);
	my @sl = split(/\t/, $line);
	my $diff = $sl[2] - $sl[1];
	$lad_total += $diff;
}

open (GADS, $gad) || die "Cannot open $lad $!\n";

while (my $line = <GADS>) {
	chomp($line);
	my @sl = split(/\t/, $line);
	my $diff = $sl[2] - $sl[1];
	$gad_total += $diff;
}

my $only_lad = $lad_total - $ints;
my $only_gad = $gad_total - $ints;

my $only_lad_pc = ($only_lad / $lad_total) * 100;
my $only_gad_pc = ($only_gad / $gad_total) * 100;

my $lad_int_pc = ($ints / $lad_total) * 100;
my $gad_int_pc = ($ints / $gad_total) * 100;

my $ints_mb = $ints / 1000000;
my $only_lad_mb = $only_lad / 1000000;
my $only_gad_mb = $only_gad / 1000000;
my $union_mb = $union / 1000000;

print "\n#'#$lad vs $gad#'#\n";
print "\n###Intersection###\n";
print "\n*megabase*\n";
print "Intersection\t$ints_mb\nOnly LADs\t$only_lad_mb\nOnly GADs\t$only_gad_mb\nUnion\t$union_mb\n";
print "\n*percentage*\n";
print "LADsOutsideInt\t$only_lad_pc\nLADsInsideInt\t$lad_int_pc\nGADsOutsideInt\t$only_gad_pc\nGADsInsideInt\t$gad_int_pc\n";
