#!usr/bin/perl
use strict;
use warnings;

# requires installation of bedtools.

my @files = qx(ls *.bed); # bed files created by a_getPeakLengths_dividePeaks_getCoverage.pl; use in same folder.

@files = sort @files;

my @use_files;

foreach my $file (@files) {
        chomp($file);
        push(@use_files, $file) if $file !~ "cov";
}

my $count_till = @use_files;
my @matrix = array($count_till, $count_till);

for (my $i = 0; $i < $count_till; $i++) { # calculated jaccard index overlap for peaks.
        for (my $j = $i + 1; $j < $count_till; $j++) {
                my $jaccard = qx(bedtools jaccard -a $use_files[$i] -b $use_files[$j]);
                my @js = split(/\s/, $jaccard);
                pop(@js);
                my $index = pop(@js);
                $matrix[$i][$j] = $index;
                $matrix[$j][$i] = $index;
                #print "$files[$i]\t$files[$j]\n";
                #print "$jaccard\n";
        }
}


foreach my $file (@use_files) {
	my @sf = split(/_|\./, $file);
	pop(@sf);
	shift(@sf);
	my $out = join("_", shift(@sf), pop(@sf));
	print "$out\n";
}

foreach my $file (@use_files) {
	my @sf = split(/_|\./, $file);
	pop(@sf);
	shift(@sf);
	my $out = join("_", shift(@sf), pop(@sf));
	print "$out\t";
}

print "\n";

print "@$_\n" for @matrix; # prints overlap values to a file in the form of a matrix.

sub array {
    my ($x, $y) = @_;
    map {[ (1) x $x ]} 1 .. $y;
}

