#!usr/bin/perl
use strict;
use warnings;

my @genes = qx(ls ../d_peakDivisionExpr/*.bed); # insetersecBed file with both bed files (eg. intersectBed -wa -wb -a <GenesFile> -b <PeakFile> > Day-2.bed )

chomp($_) foreach @genes;

my @files = qx(ls *.bed); # edd peaks for GlcNAC

@files = sort {$a cmp $b} @files;

my @use_files;

foreach my $file (@files) {
        chomp($file);
        push(@use_files, $file) if $file !~ "cov";
}

#my $count_till = @use_files;
#my @matrix = array($count_till, $count_till);

my %gene_count;
my %peaks_length;

foreach my $file (@genes) {
	chomp($file);
	my $new = qx(wc -l $file);
	my @new1 = split(/ /, $new);
	my $count = shift(@new1);
	my @sf = split(/\//, $file);
	my @sl = split(/\.|_/, pop(@sf));
	my $tp = shift(@sl);
	my $size = shift(@sl);
	$gene_count{$tp}{$size} = $count;
}

foreach my $file (@use_files) {
	chomp($file);
	open (FILE, $file) || die "Cannot open $file\n";
	my @sf = split(/_|\./, $file);
	my @tp = split(/D/, $sf[1]);
	my $time = join("", "Day", pop(@tp));
	pop(@sf);
	my $size = pop(@sf);
	my $total_length = 0;
	while (my $line = <FILE>) {
		chomp($line);
		my @sl = split (/\t/, $line);
		$total_length += $sl[2] - $sl[1];
	}
	$total_length = $total_length / 1000000;
	$peaks_length{$time}{$size} = $total_length;
}

foreach my $tp (keys %gene_count) {
	foreach my $size (keys %{$gene_count{$tp}}) {
		my $gene_count = $gene_count{$tp}{$size};
		my $peak_cov = $peaks_length{$tp}{$size};
		my $gene_per_mb = $gene_count / $peak_cov;
		print "$tp\t$size\t$gene_per_mb\n";
	}
}
