#!usr/bin/perl
use strict;
use warnings;
use threads;
use threads::shared;

# requires installation of bedtools and threads from CPAN.

my @files = qx(ls ../a_peaks/LMNA_D*.bed); # peak files

my @lengths;

foreach my $file (@files) {
	chomp($file);
	open(FILE, $file) || die "Cannot open $!\n";
	while (my $line = <FILE>) {
		chomp($line);
		my @sl = split(/\t/, $line);
		my $length = $sl[2] - $sl[1];
		push(@lengths, $length);
	}
	close(FILE);
}

open (OUT, ">", "test") || die "Cannot open OUT\n";

print OUT "$_\n" foreach @lengths; # prints the lengths in a file; temp storage of numbers. can be deleted.

@lengths = sort {$a <=> $b} @lengths;
my $num_of_peaks = @lengths;
my $uq = (3 * $num_of_peaks) / 4;
$uq = $lengths[$uq];
my $lq = $num_of_peaks / 4;
$lq = $lengths[$lq];

print "$lq\t$uq\n"; # prints the quantile ranges to divide in small medium large

my @new_beds;

foreach my $file (@files) { ## makes separate files for peaks in the subsections
	chomp($file);
	my @sf = split(/\//, $file);
	my @name = split(/\./, pop(@sf));
	my $new_small = join("_", $name[0], "small.bed");
	my $new_medium = join("_", $name[0], "medium.bed");
	my $new_large = join("_", $name[0], "large.bed");
	open(FILE, $file) || die "Cannot open $!\n";
	open (OUTS, ">", $new_small) || die "Cannot open $!\n";
	open (OUTM, ">", $new_medium) || die "Cannot open $!\n";
	open (OUTL, ">", $new_large) || die "Cannot open $!\n";
	push(@new_beds, $new_small, $new_medium, $new_large);
	while (my $line = <FILE>) {
		chomp($line);
		my @sl = split(/\t/, $line);
		my $length = $sl[2] - $sl[1];
		if ($length >= $uq) {
			print OUTL "$line\n";
		}
		elsif ($length < $uq && $length > $lq) {
			print OUTM "$line\n";
		}
		elsif ($length <= $lq) {
			print OUTS "$line\n";
		}
		else {
			print "$line\n";
		}
	}
}

print "Starting threads\n";

my @threads;
my $max_count = @new_beds;

for (my $count = 0; $count < $max_count; $count++) {
        my $t = threads->new(\&sub1, $new_beds[$count]); #starts subroutine in separate thread
        push(@threads,$t);
}
foreach (@threads) {
        my $num = $_->join;
        #print "done with $num\n";
}
print "Done\n";
 
sub sub1 { # calculates coverage of the genome for each of the divided peak files. 
        my $num = shift;
        print "started thread $num\n";
        my @sf = split(/\./, $num);
        my $cov = join ("_", $sf[0], "cov.bed");
        qx(genomeCoverageBed -i $num -g /data/as/annotation/Homo_sapiens/UCSC/hg19/GenomeStudio/Homo_sapiens/UCSC-hg19/ChromInfo.txt > $cov);
        #print "done with thread $num\n";
        return $num;
}

