#!/usr/bin/env perl

use strict;
use warnings;
use Classes::Chrommap;
use Classes::Regions;
use Classes::Frequencies;

# written by Alexander Nater, December 2013

# Set your options here:
my $chrommap_file="/proj/b2010010/repos/assembly/fAlb15/linkage/fAlb15.chrom.all.20140121.txt";
my $mafsfolder="/proj/nobackup/b2010010/alexn/mafs";
my $mafslist="/home/alexn/glob/genomescan_freq/mafslist.txt";
my $npopulations=10;
my @poplabels=("I", "H", "CZC", "OC", "E", "SP", "CZP", "OP", "spec", "semi");
my @nindividuals=(20, 20, 20, 19, 20, 20, 20, 19, 20, 20);
my @minind=(10, 10, 10, 10, 10, 10, 10, 10, 10, 10);
my @popgroups=( [0, 1, 2, 3], [4, 5, 6, 7], [8], [9] );
my @grouplabels=("Collared", "Pied", "Atlas", "Semi");
my $maxsize=5000000;
my $MAFfilter=0.001;
my $minpropcovered=0;
my $outfolder=shift @ARGV;
my $chromosome=shift @ARGV;
my $windowsize=shift @ARGV;
my $stepsize=shift @ARGV;
my @subpoplabels=split(',', shift @ARGV) if @ARGV;
my $outfile1="ssfreq_windows_" . "$chromosome" . ".bed";
my $outfile2="ssfreq_windows_" . "$chromosome" . "_translated.bed";

#-----------------------------------------------------------------------------------------------------------------------------

$outfolder=~s{/\z}{};	# remove trailing slash from folder path.
mkdir $outfolder unless (-d "$outfolder");


# prepare new arrays for population settings if subset of populations is selected:
my @subpopindices;
if (@subpoplabels && $subpoplabels[0] ne 'all'){ @subpopindices=Misc::setSubArrays(\@subpoplabels, \@poplabels, \@nindividuals, \@minind, \@popgroups, \@grouplabels) }
else { @subpopindices=(0..$npopulations-1) }
print "Selected population indices: ", join(',', @subpopindices), "\nNumber of individuals per population: ", join(',', @nindividuals), "\nMinimum number of individuals per population: ", join(',', @minind), "\n";
print "$grouplabels[$_]: ", join(',', @{ $popgroups[$_] }), "\n" foreach (0..$#popgroups);

# regions from chrommap file:
my $chrommap=Chrommap->new();
$chrommap->readChromMap($chrommap_file, 5000, 0);
my $regions=$chrommap->locifromChromMap();
my $windows=$regions->windowingLoci(0, $windowsize, $stepsize);

# get list of scaffolds for chromosome:
my @scaffolds=$chrommap->getScaffolds($chromosome);
print join(', ', @scaffolds), "\n";


SUBSET: while (1){
	my $subset=$windows->subsetLoci($maxsize, @scaffolds);
	$subset->printLoci("-");
	unless ( $subset->getSize() ){ last SUBSET }
	my $concat=$subset->concatRegions();
	$concat->printLoci("-");
	my $freqs=Frequencies->new();
	$freqs->setPops($mafsfolder, $mafslist, $npopulations, \@subpopindices);
	$freqs->readMAFs(undef, undef, scalar(@subpopindices), $concat, $MAFfilter, 0, 100);
	$subset->calculatePrivatePi($freqs, \@nindividuals, \@popgroups, $minpropcovered, \@minind);
	my $chrom_subset=$subset->translateScafftoChrom($chrommap);
	$subset->printPrivatePi("$outfolder/$outfile1", 0);
	$chrom_subset->printPrivatePi("$outfolder/$outfile2", 1);
	}


