#!/usr/bin/env perl

use strict;
use warnings;
use Classes::Chrommap;
use Classes::Regions;
use Classes::Frequencies;

# written by Alexander Nater, December 2013

# Set your options here:
my $chrommap_file="/proj/b2010010/repos/assembly/fAlb15/linkage/fAlb15.chrom.all.20140121.txt";
my $mafsfolder="/proj/nobackup/b2010010/alexn/mafs";
my $mafslist="/home/alexn/glob/genomescan_freq/mafslist.txt";
my $npopulations=10;
my @poplabels=("I", "H", "CZC", "OC", "E", "SP", "CZP", "OP", "spec", "semi");
my @nindividuals=(20, 20, 20, 19, 20, 20, 20, 19, 20, 20);
my @minind=(10, 10, 10, 10, 10, 10, 10, 10, 10, 10);
my @popgroups=( [0, 1, 2, 3], [4, 5, 6, 7], [8], [9] );
my $maxsize=5000000;
my $MAFfilter=0.001;
my $minpropcovered=0;
my $outfolder=shift @ARGV;
my $chromosome=shift @ARGV;
my $windowsize=shift @ARGV;
my $stepsize=shift @ARGV;
my $outfile1="ssfreq_windows_" . "$chromosome" . ".bed";
my $outfile2="ssfreq_windows_" . "$chromosome" . "_translated.bed";

#-----------------------------------------------------------------------------------------------------------------------------

$outfolder=~s{/\z}{};	# remove trailing slash from folder path.
mkdir $outfolder unless (-d "$outfolder");


# regions from chrommap file:
my $chrommap=Chrommap->new();
$chrommap->readChromMap($chrommap_file, 5000, 0);
my $regions=$chrommap->locifromChromMap();
my $windows=$regions->windowingLoci(0, $windowsize, $stepsize);

# get list of scaffolds for chromosome:
my @scaffolds=$chrommap->getScaffolds($chromosome);
print join(', ', @scaffolds), "\n";


SUBSET: while (1){
	my $subset=$windows->subsetLoci($maxsize, @scaffolds);
	$subset->printLoci("-");
	unless ( $subset->getSize() ){ last SUBSET }
	my $concat=$subset->concatRegions();
	$concat->printLoci("-");
	my $freqs=Frequencies->new();
	$freqs->readMAFs($mafsfolder, $mafslist, $npopulations, $concat, $MAFfilter, 0, 100);
	$subset->calculateSSfreq($freqs, \@nindividuals, \@popgroups, $minpropcovered, \@minind);
	my $chrom_subset=$subset->translateScafftoChrom($chrommap);
	$subset->printLociSS("$outfolder/$outfile1", 0);
	$chrom_subset->printLociSS("$outfolder/$outfile2", 1);
	}



