
# Function from https://github.com/ANGSD/angsd/blob/master/R/jackKnife.R 
blockJackUneven<-function(dat){
  nblocks<-nrow(dat)
  X<-cbind(dat[,1]-dat[,2],dat[,1]+dat[,2],dat[,3])
  theta<-function(x) sum(x[,1])/sum(x[,2])
  thetaEst<-theta(X)
  etai<-rep(0, nblocks)
  blockSize<-X[,3]
  blockFrac<-blockSize/sum(blockSize)

  for(i in 1:nblocks)
    etai[i]<-theta(X[-i,])
 
  meanJack<-mean(etai)
  jackEst<-nblocks*thetaEst-sum((1-blockFrac)*etai)
  jackVar<-1/nblocks * sum( 1/(1/blockFrac-1) * (1/blockFrac*thetaEst-(1/blockFrac-1)*etai - nblocks*thetaEst+sum((1-blockFrac)*etai))^2)
 return(c(jackVar,jackEst,thetaEst,0,0))
}



setwd('~/Documents/Plots/all_200kb_200kb_abba_baba')
prefix<-"all_200kb_200kb"
comps<-c("EP_A_IC", "EP_A_SC", "EP_IC_SC", "IC_CZC_CZP", "IC_OC_OP", "H_OC_OP", "EP_CZP_CZC", "EP_OP_OC", "A_IC_SC")
windowsize<-5000000
jackest<-matrix(nrow=length(comps), ncol=5)
rownames(jackest)<-comps
colnames(jackest)<-c("jackVar", "jackEst", "thetaEst", "sd", "p-value")

for (comp in 1:length(comps) ){
  filename<-paste(prefix, "_", comps[comp], "_translated_sorted.bed", sep="")
  DF<-read.table(file=filename, header=FALSE)
  blockdata<-data.frame()
  for (chr in levels(DF$V1)){
    if (max(DF[which(DF$V1==chr),3])<windowsize) next
	windowstart<-seq.int(0, max(DF[which(DF$V1==chr),2]), by=windowsize)
	windowend<-seq.int(windowsize, max(DF[which(DF$V1==chr),3]), by=windowsize)
	sums<-matrix(nrow=length(windowend), ncol=4)
	for (row in 1:length(windowend)){
		sums[row,]<-apply(na.omit(DF[which(DF$V1==chr & DF$V2>=windowstart[row] & DF$V3<=windowend[row]),4:7]), 2, sum)
		}
	temp<-data.frame(rep(chr, length(windowend)), windowstart[1:length(windowend)], windowend, sums)
	names(temp)<-c("chr", "start", "end", "valid", "nsnps", "abba", "baba")
	blockdata<-rbind(blockdata, temp)
	}

  jackest[comp,]<-blockJackUneven( cbind(blockdata$abba, blockdata$baba, blockdata$nsnps) )
  jackest[comp,4]<-sqrt(jackest[comp,1])
  jackest[comp,5]<-2*pnorm(-abs(jackest[comp,3])/jackest[comp,4])
  }

write.table(jackest, file="dstats_all_5Mb.txt")

