import os
import sys
import getopt
import shutil
import gc
import re
import cPickle as pickle
import json
import logging
import logging.config
from collections import Counter, defaultdict

from mlib.common import util
from mlib.config import WorkerConfig
from mlib.worker.batch import Batch
logger = None

#-------------------------------------------------------------------------
# set up logging
#-------------------------------------------------------------------------
def setup():
  loggingConfig_map = { 
    'version': 1,
    'disable_existing_loggers': False,
   'formatters': {
      'verbose': {
        'format' : '%(asctime)s - %(name)s - %(levelname)s - %(message)s',
      },  
      'simple': {
          'format': '%(levelname)s %(message)s'
      },  
    },  
    'handlers': {
      'stdout': {
        'level': 'INFO',
        'level': 'DEBUG',
        'class': 'logging.StreamHandler',
        'formatter': 'verbose',
      },  
      'debugfile': {
        'level': 'DEBUG',
        'class': 'logging.FileHandler',
        'filename': os.path.join(os.getcwd(), 'debug.log'),
        'formatter': 'verbose',
      },  
    },  
    'loggers': {
      '': {
        'handlers': ['stdout', 'debugfile'],
        'level': 'INFO',
        'level': 'DEBUG',
        'propagate': False,
      },  
    }   
  }
  logging.config.dictConfig(loggingConfig_map)
  global logger
  logger = logging.getLogger(__name__)

def main(argv):
  help_str = '''
  Usage: rfa-worker.py -c <config>

  opts:
    -b, --build       scratch directory name to use, default: $TMPDIR
    -c, --config      (required) path to configuration *json file to use

    -h, --help        print this message
  '''
  argShortName_str = 'hc:b:'
  argLongName_list = [
    'help',
    'config=',
    'build=',
  ]

  # parse options + setup
  #----------------------
  try:
    opts, args = getopt.getopt(argv[1:],argShortName_str, argLongName_list)
  except getopt.GetoptError as err:
    print str(err)
    sys.exit(2)

  scratch_path = None
  config_path = None
  for flag, value in opts:
    if flag in ('-h', '--help'):
       print help_str
       sys.exit(0)
    elif flag in ('-c', '--config'):
      config_path = value
    elif flag in ('-b', '--build'):
      scratch_path = value

  assert None not in [ 
    config_path,
  ]

  setup()

  if scratch_path == None:
    tmpdir_path = os.environ.get('TMPDIR')
    if tmpdir_path == None:
      logger.error('no scratch directory specified and $TMPDIR not valid')
      sys.exit(1)
    else:
      scratch_path = tmpdir_path

  # load config file
  config = WorkerConfig.fromJson(config_path)

  util.mkdir_p(scratch_path)
  with util.cd(scratch_path):
    worker = config.worker_cls(config)
    worker.run()
    worker.deliver()

if __name__ == '__main__':
  main(sys.argv)

