import sys
import os
import pysam
import subprocess
import shutil
import getopt
import shlex
from itertools import izip
from collections import defaultdict, Counter

def fastqIter(fq):
  linesPerRead = 4
  def grouped(iterator):
    while True:
      vals = tuple(next(iterator, None) for _ in xrange(linesPerRead))
      if None not in vals:
        yield vals
      else:
        raise StopIteration

  assert os.path.isfile(fq)
  with open(fq) as f:
    for (qname_ln, bases, c, bqs) in grouped(f):
      # strip aux fields
      qname_w = qname_ln.split()[0]
      # strip /1,/2
      qname = qname_w.split('/')[0]
      # strip @
      qname = qname[1:]
      txt = ''.join([qname_ln, bases, c, bqs])
      yield (qname, txt)

  raise StopIteration

