#! /usr/bin/env bash

INDEX_PATH=$1
READS1FQ=$2
READS2FQ=$3
OUTPREFIX=$4
ARGS=$5

OUTPREFIX_PATH=${OUTPREFIX}
TMPBAM=./$(basename $OUTPREFIX).tmp.bam

echo "inputs: "
echo " INDEX_PATH = $INDEX_PATH"
echo " READS1FQ   = $READS1FQ"
echo " READS2FQ   = $READS2FQ"
echo " OUTPREFIX  = $OUTPREFIX"
echo " ARGS       = $ARGS"

NUM_THREADS=8

BOWTIE=bowtie2
SAMTOOLS=samtools

if [[ -z $READS2FQ ]]; then
  READ_ARGS="-U $READS1FQ"
else
  READ_ARGS="-1 $READS1FQ -2 $READS2FQ"
fi

# bowtie
echo "running bowtie"
echo "$BOWTIE $ARGS -p $NUM_THREADS -x $INDEX_PATH $READ_ARGS -S $TMPBAM"
time $BOWTIE $ARGS -p $NUM_THREADS -x $INDEX_PATH $READ_ARGS -S $TMPBAM

# sorty
echo "sorting"
time cat $TMPBAM | $SAMTOOLS view -bS - | $SAMTOOLS sort - $OUTPREFIX_PATH
samtools index $OUTPREFIX_PATH.bam

echo "done success"

