import pysam

class CandAlignment(object):

  # {moleculo, cookiesim}
  qnameType = 'moleculo'

  @classmethod
  def setSimMode(cls):
    cls.qnameType = 'cookiesim'

  def __init__(
    self,
    cid,
    chrName,
    read,
    auxInfo,
    edits_map,
  ):
    self.cid = cid
    self.qname = read.qname
    self.qid = read.qname
    self.rid = (read.qname, read.is_read1)
    self.chrName = chrName
    self.pos = read.pos
    self.aend = read.aend
    self.isBarcode = CandAlignment.__isBarcode__(read)
    self.isTrue = CandAlignment.__isTrue__(read, chrName)
    self.truePos = CandAlignment.__getTruePos__(read)

    self.ED = auxInfo.ED
    self.AS = auxInfo.AS

    # <pos> : {acgt}
    self.edits_map = edits_map

  def __str__(self):
    return 'read:(rid:{0}, coord:{1}:{2}-{3}, edits:{4})'.format(
      self.rid,
      self.chrName,
      self.pos,
      self.aend,
      self.edits_map,
    )

  @staticmethod
  def __isBarcode__(read):
    if CandAlignment.qnameType == 'cookiesim':
      return read.qname.endswith('_bar')
    else:
      assert CandAlignment.qnameType == 'moleculo'
      return 'STRIPPED' in read.qname

  @staticmethod
  def __isTrue__(read, chrName):
    if CandAlignment.qnameType == 'cookiesim':
      tpos = CandAlignment.__getTruePos__(read)
      return (tpos == (chrName, read.pos))
    else:
      assert CandAlignment.qnameType == 'moleculo'
      return False

  @staticmethod
  def __getTruePos__(read):
    if CandAlignment.qnameType == 'cookiesim':
      (_, loc_str, _) = read.qname.split('_')
      (chrName, begin1_str, begin2_str) = loc_str.split('-')
      begin1 = int(begin1_str)
      begin2 = int(begin2_str)
      begin = begin1 if read.is_read1 else begin2
      return (chrName, begin)
    else:
      assert CandAlignment.qnameType == 'moleculo'
      return None
