#!/usr/bin/perl
use strict;
use warnings;
use diagnostics;
use List::Util qw (min max sum); 
$|=1;

##### Single CGI Finder #######
#Purpose: To find single CGIs

#Fiorella C Grandi. 
#Last revision: 07/25/2014

#Declare Variables 
my %hash;
my @array;
my @array2;
my @distances;
my @minimum1;
my @minimum2;
my @minimum3;


##DATA INPUT

#input the CGI data
open INPUT,"test_CGI.txt" or die "Couldn't open file1: $!\n";
my $tmpvar1; #CGI start
my $tmpvar2; #CGI end
my $island_start;
my $island_end;

while (<INPUT>) {
  ($tmpvar1, $tmpvar1) = split(/\t/, $_);
  
  $tmpvar1=~s/^\s+//g; # strip white space from the beginning
  $tmpvar1=~s/\r*\n//g;
  $tmpvar1=~s/\s+$//g; # strip white space from the end
  $tmpvar2=~s/\r*\n//g;
  $tmpvar2=~s/^\s+//g; # strip white space from the beginning

  #associate the location and the parameters in a hash variable. 
          $hash{$tmpvar1} = $tmpvar2;
}
close INPUT;

#Low-High CGI files
open LOW,"test_CGIs_low.txt" or die "Couldn't open file: $!\n";
open LOWOUT, ">>test_CGI_low_single.txt";

open HIGH,"test_CGIs_high.txt" or die "Couldn't open file: $!\n";
open HIGHOUT, ">>test_CGI_high_single.txt";

#### MAIN PROGRAM###

#read into an array LOW CGIs
foreach my $line (<LOW>) {
  chomp ($line);
  @array= split("\t", $line);
  
  #define "free" zone
  $island_start = $array[0];
  $island_end = $array[0] + $array[4];
 
foreach my$key (keys %hash){
      my$distance= abs($island_start - $key);
   
      if ($distance<=10000){ #change this number to change the distance of the "single" defintion.  
	push (@array2, $key);
      }      
}
if (scalar(@array2==1)){
  #needs to be equal to 1 because the island will be 0 distances from itself. 
  print LOWOUT "$array[0]\t$array[1]\t$array[2]\t$array[3]\t$array[4]\t$array[5]\t$array[6]\n";
}
undef(@array2);
}
close LOW;
close LOWOUT

#read into an array HIGH CGIs
foreach my $line (<HIGH>) {
  chomp ($line);
  @array= split("\t", $line);
  
  #define "free" zone
  $island_start = $array[0];
  $island_end = $array[0] + $array[4];
 
foreach my$key (keys %hash){
      my$distance= abs($island_start - $key);
      
      if ($distance<=10000){ #change this number to change the distance of the "single" defintion.  
	push (@array2, $key);
      }      
}
if (scalar(@array2==1)){
  #needs to be equal to 1 because the island will be 0 distances from itself. 
  print HIGHOUT "$array[0]\t$array[1]\t$array[2]\t$array[3]\t$array[4]\t$array[5]\t$array[6]\n";
}
undef(@array2);
}

close HIGH;
close HIGHOUT
