#!/usr/bin/perl

use strict;
use Node;
use Sequence;

package Gene;

#######################################################################################################################
sub new {
        my $class = shift;
        my $self = {
                _id => shift,
                _seq => shift,
                _start => shift,
                _end => shift,
                _strand => shift,
                _node => shift,
        };

	($self->{_start}, $self->{_end}) = ($self->{_end}, $self->{_start}) if($self->{_start} > $self->{_end});

        bless $self, $class;

        return $self;
}

#######################################################################################################################
sub id {
        my ( $self ) = shift;

        return $self->{_id};
}

#######################################################################################################################
sub seq {
        my ( $self ) = shift;

        return $self->{_seq};
}

#######################################################################################################################
sub strand {
        my ( $self ) = shift;

        return $self->{_strand};
}

#######################################################################################################################
sub start {
        my ( $self ) = shift;

        return $self->{_start};
}

#######################################################################################################################
sub end {
        my ( $self ) = shift;

        return $self->{_end};
}

#######################################################################################################################
sub length {
        my ( $self ) = shift;

        return ($self->{_end} - $self->{_start} + 1);
}

#######################################################################################################################
sub node {
        my ( $self ) = shift;

	($self->{_node} = $_[0]) if(@_ > 0);

        return $self->{_node};
}

1;
